package com.lib.datagenproviders;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.lib.Callisto;
import com.lib.core.util.StringCursor;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.class_2405;
import net.minecraft.class_3414;
import net.minecraft.class_7403;
import net.minecraft.class_7784;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;

public class CallistoLibSoundProvider implements class_2405 {
    protected final FabricDataOutput dataOutput;
    private final Map<String, Set<SoundEventWrapper>> sounds;
    private final boolean extractVariants;

    public CallistoLibSoundProvider(FabricDataOutput dataOutput) {
        this(dataOutput, true);
    }

    public CallistoLibSoundProvider(FabricDataOutput dataOutput, boolean extractVariants) {
        this.sounds = new HashMap();
        this.dataOutput = dataOutput;
        this.extractVariants = extractVariants;
    }

    private boolean canAdd(String name, boolean check) {
        return check && !checkName(name);
    }

    public void addSound(String name, class_3414 event) {
        this.addSound(name, true, event);
    }

    public void addSound(String name, boolean check, class_3414 event) {
        if (!this.canAdd(name, check)) {
            ((Set)this.sounds.computeIfAbsent(name, (s) -> new HashSet())).add(new SoundEventWrapper(event));
        }
    }

    public void addSound(String name, class_3414... events) {
        this.addSound(name, true, events);
    }

    public void addSound(String name, boolean check, class_3414... events) {
        if (!this.canAdd(name, check)) {
            Set<SoundEventWrapper> set = (Set)this.sounds.computeIfAbsent(name, (s) -> new HashSet());

            for(class_3414 event : events) {
                set.add(new SoundEventWrapper(event));
            }

        }
    }

    public CompletableFuture<?> method_10319(class_7403 writer) {
        getSoundsFromMod(this.dataOutput.getModId()).forEach((sound) -> {
            String path = sound.method_14833().method_12832();
            this.addSound(path, false, sound);
            if (this.extractVariants) {
                String newPath = extractPath(path);
                if (newPath == null) {
                    return;
                }

                this.addSound(newPath, false, sound);
            }

        });
        JsonObject soundsJson = new JsonObject();
        this.sounds.forEach((soundName, soundEvents) -> soundsJson.add(soundName, serializeSounds(soundEvents)));
        return class_2405.method_10320(writer, soundsJson, this.getOutputPath());
    }

    public Path getOutputPath() {
        return this.dataOutput.method_45972(class_7784.class_7490.field_39368).resolve(this.dataOutput.getModId()).resolve("sounds.json");
    }

    public String method_10321() {
        return "Sound Definitions";
    }

    private static JsonObject serializeSounds(Iterable<SoundEventWrapper> wrappers) {
        JsonObject obj = new JsonObject();
        JsonArray sounds = new JsonArray();

        for(SoundEventWrapper wrapper : wrappers) {
            sounds.add(wrapper.event.method_14833().toString());
        }

        obj.add("sounds", sounds);
        return obj;
    }

    private static @Nullable String extractPath(String path) {
        StringCursor cursor = new StringCursor(path, path.length() - 1, -1);

        while(Character.isDigit(cursor.peek())) {
            cursor.next();
        }

        return cursor.substring();
    }

    private static boolean checkName(String name) {
        if (name.contains(" ")) {
            Callisto.LOGGER.error("Sound event name cannot contain spaces: {}", name);
            return false;
        } else {
            char[] var1 = name.toCharArray();
            int var2 = var1.length;

            for(int var3 = 0; var3 < var2; ++var3) {
                Character character = var1[var3];
                if (Character.isUpperCase(character)) {
                    Callisto.LOGGER.error("Sound event name cannot contain capital letters: {}", name);
                    return false;
                }
            }

            return true;
        }
    }

    public static Stream<class_3414> getSoundsFromMod(String namespace) {
        return class_7923.field_41172.method_10220().filter((sound) -> sound.method_14833().method_12836().equals(namespace));
    }

    static class SoundEventWrapper {
        private final class_3414 event;

        public SoundEventWrapper(class_3414 event) {
            this.event = event;
        }

        public int hashCode() {
            return this.event.method_14833().hashCode();
        }
    }
}