/*
 * Decompiled with CFR 0.152.
 */
package com.aitextras.datagen;

import com.aitextras.core.AITExtrasBlocks;
import com.aitextras.core.AITExtrasItemGroups;
import com.aitextras.core.AITExtrasItems;
import com.aitextras.datagen.providers.AITExtrasAchievementProvider;
import com.aitextras.datagen.providers.AITExtrasItemTagProvider;
import com.aitextras.datagen.providers.AITExtrasModelGen;
import com.aitextras.datagen.providers.AITExtrasRecipeProvider;
import com.aitextras.datagen.providers.AITExtrasWorldGenerator;
import com.aitextras.world.AITExtrasConfiguredFeature;
import com.aitextras.world.AITExtrasPlacedFeatures;
import dev.amble.ait.core.AITBlocks;
import dev.amble.ait.core.AITItems;
import dev.amble.lib.datagen.lang.AmbleLanguageProvider;
import dev.amble.lib.datagen.lang.LanguageType;
import dev.amble.lib.datagen.loot.AmbleBlockLootTable;
import dev.amble.lib.datagen.sound.AmbleSoundProvider;
import dev.amble.lib.datagen.tag.AmbleBlockTagProvider;
import net.fabricmc.fabric.api.datagen.v1.DataGeneratorEntrypoint;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.minecraft.class_1761;
import net.minecraft.class_1802;
import net.minecraft.class_184;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2446;
import net.minecraft.class_2447;
import net.minecraft.class_2450;
import net.minecraft.class_3489;
import net.minecraft.class_7800;
import net.minecraft.class_7877;
import net.minecraft.class_7924;

public class AITExtrasDataGenerator
implements DataGeneratorEntrypoint {
    public void onInitializeDataGenerator(FabricDataGenerator gen) {
        FabricDataGenerator.Pack pack = gen.createPack();
        this.genLang(pack);
        this.generateRecipes(pack);
        this.genLoot(pack);
        this.genTags(pack);
        this.genModels(pack);
        this.generateSoundData(pack);
        this.generateItemTags(pack);
        this.generateachivement(pack);
        pack.addProvider(AITExtrasWorldGenerator::new);
    }

    private void genModels(FabricDataGenerator.Pack pack) {
        pack.addProvider((output, registriesFuture) -> {
            AITExtrasModelGen provider = new AITExtrasModelGen(output);
            provider.withBlocks(new Class[]{AITExtrasBlocks.class});
            provider.withItems(new Class[]{AITExtrasItems.class});
            return provider;
        });
    }

    public void buildRegistry(class_7877 registryBuilder) {
        registryBuilder.method_46777(class_7924.field_41239, AITExtrasConfiguredFeature::bootstrap);
        registryBuilder.method_46777(class_7924.field_41245, AITExtrasPlacedFeatures::bootstrap);
    }

    private void generateachivement(FabricDataGenerator.Pack pack) {
        pack.addProvider(AITExtrasAchievementProvider::new);
    }

    public void generateItemTags(FabricDataGenerator.Pack pack) {
        pack.addProvider(AITExtrasItemTagProvider::new);
    }

    public void generateSoundData(FabricDataGenerator.Pack pack) {
        pack.addProvider((output, registriesFuture) -> new AmbleSoundProvider(output));
    }

    private void genTags(FabricDataGenerator.Pack pack) {
        pack.addProvider((output, registriesFuture) -> new AmbleBlockTagProvider(output, registriesFuture).withBlocks(new Class[]{AITExtrasBlocks.class}));
    }

    private void genLoot(FabricDataGenerator.Pack pack) {
        pack.addProvider((output, registriesFuture) -> new AmbleBlockLootTable(output).withBlocks(new Class[]{AITExtrasBlocks.class}));
    }

    public void generateRecipes(FabricDataGenerator.Pack pack) {
        pack.addProvider((output, registriesFuture) -> {
            AITExtrasRecipeProvider provider = new AITExtrasRecipeProvider(output);
            provider.addShapedRecipe(class_2447.method_10436((class_7800)class_7800.field_40635, (class_1935)AITExtrasBlocks.EXTRAS_MONITOR_BLOCK, (int)1).method_10435("monitor").method_10439("DDD").method_10439("DED").method_10439("DCD").method_10434(Character.valueOf('D'), (class_1935)class_1802.field_8404).method_10434(Character.valueOf('C'), (class_1935)class_1802.field_23983).method_10434(Character.valueOf('E'), (class_1935)class_1802.field_8449).method_10429(class_2446.method_32807((class_1935)class_1802.field_8404), (class_184)class_2446.method_10426((class_1935)class_1802.field_8404)).method_10429(class_2446.method_32807((class_1935)class_1802.field_23983), (class_184)class_2446.method_10426((class_1935)class_1802.field_23983)).method_10429(class_2446.method_32807((class_1935)class_1802.field_8449), (class_184)class_2446.method_10426((class_1935)class_1802.field_8449)));
            provider.addShapedRecipe(class_2447.method_10436((class_7800)class_7800.field_40635, (class_1935)AITExtrasBlocks.EXTRAS_SCREEN_MONITOR_BLOCK, (int)1).method_10435("monitor").method_10439("BBB").method_10439("BEB").method_10439("BBB").method_10434(Character.valueOf('B'), (class_1935)class_1802.field_8704).method_10434(Character.valueOf('E'), (class_1935)class_1802.field_8449).method_10429(class_2446.method_32807((class_1935)class_1802.field_8704), (class_184)class_2446.method_10426((class_1935)class_1802.field_8704)).method_10429(class_2446.method_32807((class_1935)class_1802.field_8449), (class_184)class_2446.method_10426((class_1935)class_1802.field_8449)));
            provider.addShapedRecipe(class_2447.method_10436((class_7800)class_7800.field_40635, (class_1935)AITExtrasBlocks.SUN_DIAL_BLOCK, (int)1).method_10439("NGN").method_10439("GAG").method_10439("NGN").method_10434(Character.valueOf('G'), (class_1935)class_1802.field_8695).method_10434(Character.valueOf('A'), (class_1935)class_1802.field_8236).method_10434(Character.valueOf('N'), (class_1935)class_1802.field_8397).method_10429(class_2446.method_32807((class_1935)class_1802.field_8695), (class_184)class_2446.method_10426((class_1935)class_1802.field_8695)).method_10429(class_2446.method_32807((class_1935)class_1802.field_8236), (class_184)class_2446.method_10426((class_1935)class_1802.field_8236)).method_10429(class_2446.method_32807((class_1935)class_1802.field_8397), (class_184)class_2446.method_10426((class_1935)class_1802.field_8397)));
            class_2450.method_10448((class_7800)class_7800.field_40640, (class_1935)AITExtrasItems.JELLY_BABIES, (int)1);
            provider.addShapelessRecipe(class_2450.method_10448((class_7800)class_7800.field_40640, (class_1935)AITExtrasItems.JELLY_BABIES, (int)4).method_10454((class_1935)class_1802.field_8407).method_10454((class_1935)class_1802.field_8479).method_10454((class_1935)class_1802.field_8264).method_10454((class_1935)class_1802.field_8408).method_10454((class_1935)class_1802.field_8669).method_10454((class_1935)class_1802.field_8192).method_10442(class_2446.method_32807((class_1935)class_1802.field_8407), (class_184)class_2446.method_10426((class_1935)class_1802.field_8407)).method_10442(class_2446.method_32807((class_1935)class_1802.field_8479), (class_184)class_2446.method_10426((class_1935)class_1802.field_8479)));
            provider.addShapelessRecipe(class_2450.method_10448((class_7800)class_7800.field_40640, (class_1935)AITExtrasItems.CUSTARD_CREAM, (int)4).method_10454((class_1935)class_1802.field_8103).method_10454((class_1935)class_1802.field_8479).method_10454((class_1935)class_1802.field_8803).method_10442(class_2446.method_32807((class_1935)class_1802.field_8103), (class_184)class_2446.method_10426((class_1935)class_1802.field_8103)).method_10442(class_2446.method_32807((class_1935)class_1802.field_8479), (class_184)class_2446.method_10426((class_1935)class_1802.field_8479)).method_10442(class_2446.method_32807((class_1935)class_1802.field_8803), (class_184)class_2446.method_10426((class_1935)class_1802.field_8803)));
            provider.addShapelessRecipe(class_2450.method_10448((class_7800)class_7800.field_40640, (class_1935)AITExtrasItems.RICE_PUDDING, (int)1).method_10454((class_1935)class_1802.field_8103).method_10454((class_1935)class_1802.field_8479).method_10454((class_1935)class_1802.field_8861).method_10454((class_1935)class_1802.field_8428).method_10442(class_2446.method_32807((class_1935)class_1802.field_8103), (class_184)class_2446.method_10426((class_1935)class_1802.field_8103)).method_10442(class_2446.method_32807((class_1935)class_1802.field_8479), (class_184)class_2446.method_10426((class_1935)class_1802.field_8479)).method_10442(class_2446.method_32807((class_1935)class_1802.field_8861), (class_184)class_2446.method_10426((class_1935)class_1802.field_8861)).method_10442(class_2446.method_32807((class_1935)class_1802.field_8428), (class_184)class_2446.method_10426((class_1935)class_1802.field_8428)));
            provider.addShapedRecipe(class_2447.method_10436((class_7800)class_7800.field_40635, (class_1935)AITExtrasBlocks.HAT_STAND_OAK_BLOCK, (int)1).method_10435("hat_stand").method_10439("FFF").method_10439(" F ").method_10439(" F ").method_10434(Character.valueOf('F'), (class_1935)class_1802.field_8792).method_10429(class_2446.method_32807((class_1935)class_1802.field_8792), (class_184)class_2446.method_10426((class_1935)class_1802.field_8792)));
            provider.addShapedRecipe(class_2447.method_10436((class_7800)class_7800.field_40635, (class_1935)AITExtrasBlocks.HAT_STAND_ACACIA_BLOCK, (int)1).method_10435("hat_stand").method_10439("FFF").method_10439(" F ").method_10439(" F ").method_10434(Character.valueOf('F'), (class_1935)class_1802.field_8646).method_10429(class_2446.method_32807((class_1935)class_1802.field_8646), (class_184)class_2446.method_10426((class_1935)class_1802.field_8646)));
            provider.addShapedRecipe(class_2447.method_10436((class_7800)class_7800.field_40635, (class_1935)AITExtrasBlocks.HAT_STAND_BAMBOO_BLOCK, (int)1).method_10435("hat_stand").method_10439("FFF").method_10439(" F ").method_10439(" F ").method_10434(Character.valueOf('F'), (class_1935)class_1802.field_40218).method_10429(class_2446.method_32807((class_1935)class_1802.field_40218), (class_184)class_2446.method_10426((class_1935)class_1802.field_40218)));
            provider.addShapedRecipe(class_2447.method_10436((class_7800)class_7800.field_40635, (class_1935)AITExtrasBlocks.HAT_STAND_BIRCH_BLOCK, (int)1).method_10435("hat_stand").method_10439("FFF").method_10439(" F ").method_10439(" F ").method_10434(Character.valueOf('F'), (class_1935)class_1802.field_8457).method_10429(class_2446.method_32807((class_1935)class_1802.field_8457), (class_184)class_2446.method_10426((class_1935)class_1802.field_8457)));
            provider.addShapedRecipe(class_2447.method_10436((class_7800)class_7800.field_40635, (class_1935)AITExtrasBlocks.HAT_STAND_CHERRY_BLOCK, (int)1).method_10435("hat_stand").method_10439("FFF").method_10439(" F ").method_10439(" F ").method_10434(Character.valueOf('F'), (class_1935)class_1802.field_42698).method_10429(class_2446.method_32807((class_1935)class_1802.field_42698), (class_184)class_2446.method_10426((class_1935)class_1802.field_42698)));
            provider.addShapedRecipe(class_2447.method_10436((class_7800)class_7800.field_40635, (class_1935)AITExtrasBlocks.HAT_STAND_CRIMSON_BLOCK, (int)1).method_10435("hat_stand").method_10439("FFF").method_10439(" F ").method_10439(" F ").method_10434(Character.valueOf('F'), (class_1935)class_1802.field_21995).method_10429(class_2446.method_32807((class_1935)class_1802.field_21995), (class_184)class_2446.method_10426((class_1935)class_1802.field_21995)));
            provider.addShapedRecipe(class_2447.method_10436((class_7800)class_7800.field_40635, (class_1935)AITExtrasBlocks.HAT_STAND_DARK_OAK_BLOCK, (int)1).method_10435("hat_stand").method_10439("FFF").method_10439(" F ").method_10439(" F ").method_10434(Character.valueOf('F'), (class_1935)class_1802.field_8454).method_10429(class_2446.method_32807((class_1935)class_1802.field_8454), (class_184)class_2446.method_10426((class_1935)class_1802.field_8454)));
            provider.addShapedRecipe(class_2447.method_10436((class_7800)class_7800.field_40635, (class_1935)AITExtrasBlocks.HAT_STAND_JUNGLE_BLOCK, (int)1).method_10435("hat_stand").method_10439("FFF").method_10439(" F ").method_10439(" F ").method_10434(Character.valueOf('F'), (class_1935)class_1802.field_8823).method_10429(class_2446.method_32807((class_1935)class_1802.field_8823), (class_184)class_2446.method_10426((class_1935)class_1802.field_8823)));
            provider.addShapedRecipe(class_2447.method_10436((class_7800)class_7800.field_40635, (class_1935)AITExtrasBlocks.HAT_STAND_MANGROVE_BLOCK, (int)1).method_10435("hat_stand").method_10439("FFF").method_10439(" F ").method_10439(" F ").method_10434(Character.valueOf('F'), (class_1935)class_1802.field_37520).method_10429(class_2446.method_32807((class_1935)class_1802.field_37520), (class_184)class_2446.method_10426((class_1935)class_1802.field_37520)));
            provider.addShapedRecipe(class_2447.method_10436((class_7800)class_7800.field_40635, (class_1935)AITExtrasBlocks.HAT_STAND_SPRUCE_BLOCK, (int)1).method_10435("hat_stand").method_10439("FFF").method_10439(" F ").method_10439(" F ").method_10434(Character.valueOf('F'), (class_1935)class_1802.field_8701).method_10429(class_2446.method_32807((class_1935)class_1802.field_8701), (class_184)class_2446.method_10426((class_1935)class_1802.field_8701)));
            provider.addShapedRecipe(class_2447.method_10436((class_7800)class_7800.field_40635, (class_1935)AITExtrasBlocks.HAT_STAND_WARPED_BLOCK, (int)1).method_10435("hat_stand").method_10439("FFF").method_10439(" F ").method_10439(" F ").method_10434(Character.valueOf('F'), (class_1935)class_1802.field_21996).method_10429(class_2446.method_32807((class_1935)class_1802.field_21996), (class_184)class_2446.method_10426((class_1935)class_1802.field_21996)));
            provider.addShapedRecipe(class_2447.method_10436((class_7800)class_7800.field_40635, (class_1935)AITExtrasBlocks.CRYSTAL_ZEITON_BLOCK, (int)1).method_10435("crystal").method_10439(" Z ").method_10439(" B ").method_10439(" Z ").method_10434(Character.valueOf('B'), (class_1935)AITBlocks.ZEITON_BLOCK).method_10434(Character.valueOf('Z'), (class_1935)AITItems.ZEITON_SHARD).method_10429(class_2446.method_32807((class_1935)AITBlocks.ZEITON_BLOCK), (class_184)class_2446.method_10426((class_1935)AITBlocks.ZEITON_BLOCK)));
            provider.addShapedRecipe(class_2447.method_10436((class_7800)class_7800.field_40635, (class_1935)AITExtrasBlocks.CRYSTAL_MASTER_BLOCK, (int)1).method_10435("crystal").method_10439(" A ").method_10439(" B ").method_10439(" Z ").method_10434(Character.valueOf('B'), (class_1935)AITBlocks.ZEITON_BLOCK).method_10434(Character.valueOf('Z'), (class_1935)AITItems.ZEITON_SHARD).method_10434(Character.valueOf('A'), (class_1935)class_1802.field_27063).method_10429(class_2446.method_32807((class_1935)class_2246.field_27159), (class_184)class_2446.method_10426((class_1935)class_2246.field_27159)));
            provider.addShapedRecipe(class_2447.method_10436((class_7800)class_7800.field_40635, (class_1935)AITExtrasBlocks.CRYSTAL_BLOCK, (int)1).method_10435("crystal").method_10439(" C ").method_10439(" B ").method_10439(" C ").method_10434(Character.valueOf('B'), (class_1935)AITExtrasBlocks.CRYSTALLINE_SHARD_BLOCK).method_10434(Character.valueOf('C'), (class_1935)AITExtrasItems.CRYSTALLINE_SHARD).method_10429(class_2446.method_32807((class_1935)AITExtrasBlocks.CRYSTALLINE_SHARD_BLOCK), (class_184)class_2446.method_10426((class_1935)AITExtrasBlocks.CRYSTALLINE_SHARD_BLOCK)));
            provider.addShapedRecipe(class_2447.method_10436((class_7800)class_7800.field_40642, (class_1935)AITExtrasBlocks.CRYSTALLINE_SHARD_BLOCK, (int)1).method_10439("CCC").method_10439("CCC").method_10439("CCC").method_10434(Character.valueOf('C'), (class_1935)AITExtrasItems.CRYSTALLINE_SHARD).method_10429(class_2446.method_32807((class_1935)AITExtrasItems.CRYSTALLINE_SHARD), (class_184)class_2446.method_10426((class_1935)AITExtrasItems.CRYSTALLINE_SHARD)));
            provider.addShapedRecipe(class_2447.method_10436((class_7800)class_7800.field_40642, (class_1935)AITExtrasItems.WHISTLE, (int)1).method_10439("AAA").method_10439(" BA").method_10439("   ").method_10434(Character.valueOf('A'), (class_1935)class_1802.field_8620).method_10434(Character.valueOf('B'), (class_1935)class_1802.field_8449).method_10429(class_2446.method_32807((class_1935)class_1802.field_8620), (class_184)class_2446.method_10426((class_1935)class_1802.field_8449)));
            provider.addShapelessRecipe(class_2450.method_10448((class_7800)class_7800.field_40642, (class_1935)AITExtrasItems.ZIRCONIUM_INGOT, (int)4).method_10452("zirconium").method_10454((class_1935)class_1802.field_8620).method_10454((class_1935)AITExtrasItems.RAW_ZIRCONIUM).method_10442(class_2446.method_32807((class_1935)class_1802.field_8620), (class_184)class_2446.method_10426((class_1935)class_1802.field_8620)).method_10442(class_2446.method_32807((class_1935)AITExtrasItems.RAW_ZIRCONIUM), (class_184)class_2446.method_10426((class_1935)AITExtrasItems.RAW_ZIRCONIUM)));
            provider.addShapelessRecipe(class_2450.method_10448((class_7800)class_7800.field_40642, (class_1935)AITExtrasItems.MERCURY_DISC, (int)1).method_10452("zirconium").method_10446(class_3489.field_15541).method_10454((class_1935)AITExtrasItems.RAW_ZIRCONIUM).method_10442(class_2446.method_32807((class_1935)AITExtrasItems.RAW_ZIRCONIUM), (class_184)class_2446.method_10426((class_1935)AITExtrasItems.RAW_ZIRCONIUM)));
            provider.addShapedRecipe(class_2447.method_10436((class_7800)class_7800.field_40635, (class_1935)AITExtrasBlocks.HUDOLIN_SUPPORT_BASE_BLOCK, (int)1).method_10435("hudolin").method_10439("III").method_10439(" IA").method_10439("   ").method_10434(Character.valueOf('A'), (class_1935)AITExtrasItems.RAW_ZIRCONIUM).method_10434(Character.valueOf('I'), (class_1935)AITExtrasItems.ZIRCONIUM_INGOT).method_10429(class_2446.method_32807((class_1935)AITExtrasItems.RAW_ZIRCONIUM), (class_184)class_2446.method_10426((class_1935)AITExtrasItems.RAW_ZIRCONIUM)));
            provider.addShapedRecipe(class_2447.method_10436((class_7800)class_7800.field_40635, (class_1935)AITExtrasBlocks.HUDOLIN_SUPPORT_TOP_BLOCK, (int)1).method_10435("hudolin").method_10439("AI ").method_10439(" II").method_10439(" IA").method_10434(Character.valueOf('A'), (class_1935)AITExtrasItems.RAW_ZIRCONIUM).method_10434(Character.valueOf('I'), (class_1935)AITExtrasItems.ZIRCONIUM_INGOT).method_10429(class_2446.method_32807((class_1935)AITExtrasItems.RAW_ZIRCONIUM), (class_184)class_2446.method_10426((class_1935)AITExtrasItems.RAW_ZIRCONIUM)));
            provider.addShapedRecipe(class_2447.method_10436((class_7800)class_7800.field_40634, (class_1935)AITExtrasBlocks.POLISHED_COMPACT_ZEITON, (int)4).method_10435("polished_compact_zeiton").method_10439("ZZ").method_10439("ZZ").method_10434(Character.valueOf('Z'), (class_1935)AITBlocks.COMPACT_ZEITON).method_10429(class_2446.method_32807((class_1935)AITBlocks.COMPACT_ZEITON), (class_184)class_2446.method_10426((class_1935)AITBlocks.COMPACT_ZEITON)));
            provider.addShapedRecipe(class_2447.method_10436((class_7800)class_7800.field_40634, (class_1935)AITExtrasBlocks.POLISHED_COMPACT_ZEITON_STAIRS, (int)4).method_10435("polished_compact_zeiton").method_10439("  X").method_10439(" XX").method_10439("XXX").method_10434(Character.valueOf('X'), (class_1935)AITExtrasBlocks.POLISHED_COMPACT_ZEITON).method_10429(class_2446.method_32807((class_1935)AITExtrasBlocks.POLISHED_COMPACT_ZEITON), (class_184)class_2446.method_10426((class_1935)AITExtrasBlocks.POLISHED_COMPACT_ZEITON)));
            provider.addShapedRecipe(class_2447.method_10436((class_7800)class_7800.field_40634, (class_1935)AITExtrasBlocks.POLISHED_COMPACT_ZEITON_SLAB, (int)6).method_10435("polished_compact_zeiton").method_10439("XXX").method_10434(Character.valueOf('X'), (class_1935)AITExtrasBlocks.POLISHED_COMPACT_ZEITON).method_10429(class_2446.method_32807((class_1935)AITExtrasBlocks.POLISHED_COMPACT_ZEITON), (class_184)class_2446.method_10426((class_1935)AITExtrasBlocks.POLISHED_COMPACT_ZEITON)));
            provider.addShapedRecipe(class_2447.method_10436((class_7800)class_7800.field_40634, (class_1935)AITExtrasBlocks.POLISHED_COMPACT_ZEITON_WALL, (int)6).method_10435("polished_compact_zeiton").method_10439("XXX").method_10439("XXX").method_10434(Character.valueOf('X'), (class_1935)AITExtrasBlocks.POLISHED_COMPACT_ZEITON).method_10429(class_2446.method_32807((class_1935)AITExtrasBlocks.POLISHED_COMPACT_ZEITON), (class_184)class_2446.method_10426((class_1935)AITExtrasBlocks.POLISHED_COMPACT_ZEITON)));
            provider.addShapedRecipe(class_2447.method_10436((class_7800)class_7800.field_40634, (class_1935)AITExtrasBlocks.COMPACT_ZEITON_BRICKS, (int)4).method_10435("compact_zeiton_bricks").method_10439("PP").method_10439("PP").method_10434(Character.valueOf('P'), (class_1935)AITExtrasBlocks.POLISHED_COMPACT_ZEITON).method_10429(class_2446.method_32807((class_1935)AITExtrasBlocks.POLISHED_COMPACT_ZEITON), (class_184)class_2446.method_10426((class_1935)AITExtrasBlocks.POLISHED_COMPACT_ZEITON)));
            provider.addShapedRecipe(class_2447.method_10436((class_7800)class_7800.field_40634, (class_1935)AITExtrasBlocks.COMPACT_ZEITON_BRICK_STAIRS, (int)4).method_10435("compact_zeiton_bricks").method_10439("  X").method_10439(" XX").method_10439("XXX").method_10434(Character.valueOf('X'), (class_1935)AITExtrasBlocks.COMPACT_ZEITON_BRICKS).method_10429(class_2446.method_32807((class_1935)AITExtrasBlocks.COMPACT_ZEITON_BRICKS), (class_184)class_2446.method_10426((class_1935)AITExtrasBlocks.COMPACT_ZEITON_BRICKS)));
            provider.addShapedRecipe(class_2447.method_10436((class_7800)class_7800.field_40634, (class_1935)AITExtrasBlocks.COMPACT_ZEITON_BRICK_SLAB, (int)6).method_10435("compact_zeiton_bricks").method_10439("XXX").method_10434(Character.valueOf('X'), (class_1935)AITExtrasBlocks.COMPACT_ZEITON_BRICKS).method_10429(class_2446.method_32807((class_1935)AITExtrasBlocks.COMPACT_ZEITON_BRICKS), (class_184)class_2446.method_10426((class_1935)AITExtrasBlocks.COMPACT_ZEITON_BRICKS)));
            provider.addShapedRecipe(class_2447.method_10436((class_7800)class_7800.field_40634, (class_1935)AITExtrasBlocks.COMPACT_ZEITON_BRICK_WALL, (int)6).method_10435("compact_zeiton_bricks").method_10439("XXX").method_10439("XXX").method_10434(Character.valueOf('X'), (class_1935)AITExtrasBlocks.COMPACT_ZEITON_BRICKS).method_10429(class_2446.method_32807((class_1935)AITExtrasBlocks.COMPACT_ZEITON_BRICKS), (class_184)class_2446.method_10426((class_1935)AITExtrasBlocks.COMPACT_ZEITON_BRICKS)));
            provider.addShapedRecipe(class_2447.method_10436((class_7800)class_7800.field_40635, (class_1935)AITExtrasBlocks.SEAL_BLOCK, (int)1).method_10435("seal").method_10439("NIN").method_10439("I I").method_10439("NIN").method_10434(Character.valueOf('I'), (class_1935)class_1802.field_8695).method_10434(Character.valueOf('N'), (class_1935)class_1802.field_8397).method_10429(class_2446.method_32807((class_1935)class_1802.field_8695), (class_184)class_2446.method_10426((class_1935)class_1802.field_8695)).method_10429(class_2446.method_32807((class_1935)class_1802.field_8397), (class_184)class_2446.method_10426((class_1935)class_1802.field_8397)));
            provider.addShapelessRecipe(class_2450.method_10448((class_7800)class_7800.field_40635, (class_1935)AITExtrasBlocks.SEAL_SMALL_BLOCK, (int)1).method_10452("seal").method_10454((class_1935)AITExtrasBlocks.SEAL_BLOCK).method_10442(class_2446.method_32807((class_1935)AITExtrasBlocks.SEAL_BLOCK), (class_184)class_2446.method_10426((class_1935)AITExtrasBlocks.SEAL_BLOCK)));
            provider.addShapedRecipe(class_2447.method_10436((class_7800)class_7800.field_40635, (class_1935)AITExtrasBlocks.CANDLE_STAND_SINGLE_BLOCK, (int)2).method_10435("candle_stand").method_10439(" C ").method_10439(" Z ").method_10439(" Z ").method_10434(Character.valueOf('C'), (class_1935)class_1802.field_27024).method_10434(Character.valueOf('Z'), (class_1935)AITExtrasItems.ZIRCONIUM_INGOT).method_10429(class_2446.method_32807((class_1935)class_1802.field_27024), (class_184)class_2446.method_10426((class_1935)class_1802.field_27024)).method_10429(class_2446.method_32807((class_1935)AITExtrasItems.ZIRCONIUM_INGOT), (class_184)class_2446.method_10426((class_1935)AITExtrasItems.ZIRCONIUM_INGOT)));
            provider.addShapedRecipe(class_2447.method_10436((class_7800)class_7800.field_40635, (class_1935)AITExtrasBlocks.CANDLE_STAND_SMALL_BLOCK, (int)2).method_10435("candle_stand").method_10439("CSC").method_10439("Z Z").method_10434(Character.valueOf('C'), (class_1935)class_1802.field_27024).method_10434(Character.valueOf('Z'), (class_1935)AITExtrasItems.ZIRCONIUM_INGOT).method_10434(Character.valueOf('S'), (class_1935)AITExtrasBlocks.CANDLE_STAND_SINGLE_BLOCK).method_10429(class_2446.method_32807((class_1935)class_1802.field_27024), (class_184)class_2446.method_10426((class_1935)class_1802.field_27024)).method_10429(class_2446.method_32807((class_1935)AITExtrasItems.ZIRCONIUM_INGOT), (class_184)class_2446.method_10426((class_1935)AITExtrasItems.ZIRCONIUM_INGOT)).method_10429(class_2446.method_32807((class_1935)AITExtrasBlocks.CANDLE_STAND_SINGLE_BLOCK), (class_184)class_2446.method_10426((class_1935)AITExtrasBlocks.CANDLE_STAND_SINGLE_BLOCK)));
            provider.addShapedRecipe(class_2447.method_10436((class_7800)class_7800.field_40635, (class_1935)AITExtrasBlocks.CANDLE_STAND_LARGE_BLOCK, (int)2).method_10435("candle_stand").method_10439("CSC").method_10439("Z Z").method_10434(Character.valueOf('C'), (class_1935)class_1802.field_27024).method_10434(Character.valueOf('Z'), (class_1935)AITExtrasItems.ZIRCONIUM_INGOT).method_10434(Character.valueOf('S'), (class_1935)AITExtrasBlocks.CANDLE_STAND_SMALL_BLOCK).method_10429(class_2446.method_32807((class_1935)class_1802.field_27024), (class_184)class_2446.method_10426((class_1935)class_1802.field_27024)).method_10429(class_2446.method_32807((class_1935)AITExtrasItems.ZIRCONIUM_INGOT), (class_184)class_2446.method_10426((class_1935)AITExtrasItems.ZIRCONIUM_INGOT)).method_10429(class_2446.method_32807((class_1935)AITExtrasBlocks.CANDLE_STAND_SMALL_BLOCK), (class_184)class_2446.method_10426((class_1935)AITExtrasBlocks.CANDLE_STAND_SMALL_BLOCK)));
            provider.addShapedRecipe(class_2447.method_10436((class_7800)class_7800.field_40635, (class_1935)AITExtrasItems.ATOMIC_SHREDDER, (int)1).method_10439("  I").method_10439("ZAZ").method_10439("Z  ").method_10434(Character.valueOf('I'), (class_1935)class_1802.field_8620).method_10434(Character.valueOf('Z'), (class_1935)AITExtrasItems.ZIRCONIUM_INGOT).method_10434(Character.valueOf('A'), (class_1935)AITItems.ARTRON_COLLECTOR).method_10429(class_2446.method_32807((class_1935)class_1802.field_27024), (class_184)class_2446.method_10426((class_1935)class_1802.field_27024)).method_10429(class_2446.method_32807((class_1935)AITExtrasItems.ZIRCONIUM_INGOT), (class_184)class_2446.method_10426((class_1935)AITExtrasItems.ZIRCONIUM_INGOT)).method_10429(class_2446.method_32807((class_1935)AITExtrasBlocks.CANDLE_STAND_SMALL_BLOCK), (class_184)class_2446.method_10426((class_1935)AITExtrasBlocks.CANDLE_STAND_SMALL_BLOCK)));
            provider.addShapedRecipe(class_2447.method_10436((class_7800)class_7800.field_40634, (class_1935)AITExtrasItems.METAL_MESH_ITEM, (int)6).method_10435("metal_mesh").method_10439("Z Z").method_10439(" Z ").method_10439("Z Z").method_10434(Character.valueOf('Z'), (class_1935)AITExtrasItems.ZIRCONIUM_INGOT).method_10429(class_2446.method_32807((class_1935)AITExtrasItems.ZIRCONIUM_INGOT), (class_184)class_2446.method_10426((class_1935)AITExtrasItems.ZIRCONIUM_INGOT)));
            provider.addShapedRecipe(class_2447.method_10436((class_7800)class_7800.field_40634, (class_1935)AITExtrasBlocks.METAL_MESH, (int)4).method_10435("metal_mesh").method_10439("MMM").method_10439("MMM").method_10439("MMM").method_10434(Character.valueOf('M'), (class_1935)AITExtrasItems.METAL_MESH_ITEM).method_10429(class_2446.method_32807((class_1935)AITExtrasItems.METAL_MESH_ITEM), (class_184)class_2446.method_10426((class_1935)AITExtrasItems.METAL_MESH_ITEM)));
            provider.addShapedRecipe(class_2447.method_10436((class_7800)class_7800.field_40634, (class_1935)AITExtrasBlocks.METAL_MESH_STAIRS, (int)4).method_10435("metal_mesh").method_10439("  M").method_10439(" MM").method_10439("MMM").method_10434(Character.valueOf('M'), (class_1935)AITExtrasItems.METAL_MESH_ITEM).method_10429(class_2446.method_32807((class_1935)AITExtrasItems.METAL_MESH_ITEM), (class_184)class_2446.method_10426((class_1935)AITExtrasItems.METAL_MESH_ITEM)));
            provider.addShapedRecipe(class_2447.method_10436((class_7800)class_7800.field_40634, (class_1935)AITExtrasBlocks.METAL_MESH_SLAB, (int)6).method_10435("metal_mesh").method_10439("MMM").method_10434(Character.valueOf('M'), (class_1935)AITExtrasItems.METAL_MESH_ITEM).method_10429(class_2446.method_32807((class_1935)AITExtrasItems.METAL_MESH_ITEM), (class_184)class_2446.method_10426((class_1935)AITExtrasItems.METAL_MESH_ITEM)));
            provider.addShapedRecipe(class_2447.method_10436((class_7800)class_7800.field_40634, (class_1935)AITExtrasBlocks.METAL_MESH_WALL, (int)4).method_10435("metal_mesh").method_10439("MMM").method_10439("MMM").method_10434(Character.valueOf('M'), (class_1935)AITExtrasItems.METAL_MESH_ITEM).method_10429(class_2446.method_32807((class_1935)AITExtrasItems.METAL_MESH_ITEM), (class_184)class_2446.method_10426((class_1935)AITExtrasItems.METAL_MESH_ITEM)));
            provider.addShapedRecipe(class_2447.method_10436((class_7800)class_7800.field_40634, (class_1935)AITExtrasBlocks.METAL_MESH_TRAPDOOR, (int)2).method_10435("metal_mesh").method_10439("MM").method_10439("MM").method_10434(Character.valueOf('M'), (class_1935)AITExtrasItems.METAL_MESH_ITEM).method_10429(class_2446.method_32807((class_1935)AITExtrasItems.METAL_MESH_ITEM), (class_184)class_2446.method_10426((class_1935)AITExtrasItems.METAL_MESH_ITEM)));
            provider.addShapedRecipe(class_2447.method_10436((class_7800)class_7800.field_40634, (class_1935)AITExtrasItems.METAL_GRATE_ITEM, (int)6).method_10435("metal_grate").method_10439("M M").method_10439(" M ").method_10439("M M").method_10434(Character.valueOf('M'), (class_1935)AITExtrasItems.METAL_MESH_ITEM).method_10429(class_2446.method_32807((class_1935)AITExtrasItems.METAL_MESH_ITEM), (class_184)class_2446.method_10426((class_1935)AITExtrasItems.METAL_MESH_ITEM)));
            provider.addShapedRecipe(class_2447.method_10436((class_7800)class_7800.field_40634, (class_1935)AITExtrasBlocks.METAL_GRATE, (int)4).method_10435("metal_grate").method_10439("MMM").method_10439("MMM").method_10439("MMM").method_10434(Character.valueOf('M'), (class_1935)AITExtrasItems.METAL_GRATE_ITEM).method_10429(class_2446.method_32807((class_1935)AITExtrasItems.METAL_GRATE_ITEM), (class_184)class_2446.method_10426((class_1935)AITExtrasItems.METAL_GRATE_ITEM)));
            provider.addShapedRecipe(class_2447.method_10436((class_7800)class_7800.field_40634, (class_1935)AITExtrasBlocks.METAL_GRATE_STAIRS, (int)4).method_10435("metal_grate").method_10439("  M").method_10439(" MM").method_10439("MMM").method_10434(Character.valueOf('M'), (class_1935)AITExtrasItems.METAL_GRATE_ITEM).method_10429(class_2446.method_32807((class_1935)AITExtrasItems.METAL_GRATE_ITEM), (class_184)class_2446.method_10426((class_1935)AITExtrasItems.METAL_GRATE_ITEM)));
            provider.addShapedRecipe(class_2447.method_10436((class_7800)class_7800.field_40634, (class_1935)AITExtrasBlocks.METAL_GRATE_SLAB, (int)6).method_10435("metal_grate").method_10439("MMM").method_10434(Character.valueOf('M'), (class_1935)AITExtrasItems.METAL_GRATE_ITEM).method_10429(class_2446.method_32807((class_1935)AITExtrasItems.METAL_GRATE_ITEM), (class_184)class_2446.method_10426((class_1935)AITExtrasItems.METAL_GRATE_ITEM)));
            provider.addShapedRecipe(class_2447.method_10436((class_7800)class_7800.field_40634, (class_1935)AITExtrasBlocks.METAL_GRATE_WALL, (int)4).method_10435("metal_grate").method_10439("MMM").method_10439("MMM").method_10434(Character.valueOf('M'), (class_1935)AITExtrasItems.METAL_GRATE_ITEM).method_10429(class_2446.method_32807((class_1935)AITExtrasItems.METAL_GRATE_ITEM), (class_184)class_2446.method_10426((class_1935)AITExtrasItems.METAL_GRATE_ITEM)));
            provider.addShapedRecipe(class_2447.method_10436((class_7800)class_7800.field_40634, (class_1935)AITExtrasBlocks.METAL_GRATE_TRAPDOOR, (int)2).method_10435("metal_grate").method_10439("MM").method_10439("MM").method_10434(Character.valueOf('M'), (class_1935)AITExtrasItems.METAL_GRATE_ITEM).method_10429(class_2446.method_32807((class_1935)AITExtrasItems.METAL_GRATE_ITEM), (class_184)class_2446.method_10426((class_1935)AITExtrasItems.METAL_GRATE_ITEM)));
            provider.addShapedRecipe(class_2447.method_10436((class_7800)class_7800.field_40634, (class_1935)AITExtrasBlocks.ARS_EGG_BLOCK, (int)2).method_10439(" I ").method_10439("SES").method_10439("ISI").method_10434(Character.valueOf('I'), (class_1935)class_1802.field_8620).method_10434(Character.valueOf('E'), (class_1935)class_1802.field_8803).method_10434(Character.valueOf('S'), (class_1935)class_2246.field_10174).method_10429(class_2446.method_32807((class_1935)class_1802.field_8620), (class_184)class_2446.method_10426((class_1935)class_1802.field_8620)).method_10429(class_2446.method_32807((class_1935)class_1802.field_8803), (class_184)class_2446.method_10426((class_1935)class_1802.field_8803)).method_10429(class_2446.method_32807((class_1935)class_2246.field_10174), (class_184)class_2446.method_10426((class_1935)class_2246.field_10174)));
            provider.addStonecutting(AITBlocks.COMPACT_ZEITON, AITExtrasBlocks.POLISHED_COMPACT_ZEITON, 1);
            provider.addStonecutting(AITExtrasBlocks.POLISHED_COMPACT_ZEITON, AITExtrasBlocks.COMPACT_ZEITON_BRICKS, 1);
            provider.addStonecutting(AITExtrasBlocks.POLISHED_COMPACT_ZEITON, AITExtrasBlocks.POLISHED_COMPACT_ZEITON_SLAB, 2);
            provider.addStonecutting(AITExtrasBlocks.POLISHED_COMPACT_ZEITON, AITExtrasBlocks.POLISHED_COMPACT_ZEITON_STAIRS, 1);
            provider.addStonecutting(AITExtrasBlocks.POLISHED_COMPACT_ZEITON, AITExtrasBlocks.POLISHED_COMPACT_ZEITON_WALL, 1);
            provider.addStonecutting(AITExtrasBlocks.COMPACT_ZEITON_BRICKS, AITExtrasBlocks.COMPACT_ZEITON_BRICK_SLAB, 2);
            provider.addStonecutting(AITExtrasBlocks.COMPACT_ZEITON_BRICKS, AITExtrasBlocks.COMPACT_ZEITON_BRICK_STAIRS, 1);
            provider.addStonecutting(AITExtrasBlocks.COMPACT_ZEITON_BRICKS, AITExtrasBlocks.COMPACT_ZEITON_BRICK_WALL, 1);
            provider.addShapedRecipe(class_2447.method_10436((class_7800)class_7800.field_40635, (class_1935)AITExtrasItems.WHITE_FEZ_HAT, (int)1).method_10435("fez").method_10439("WWW").method_10439("W W").method_10434(Character.valueOf('W'), (class_1935)class_2246.field_10446).method_10429(class_2446.method_32807((class_1935)class_2246.field_10446), (class_184)class_2446.method_10426((class_1935)class_2246.field_10446)));
            provider.addShapedRecipe(class_2447.method_10436((class_7800)class_7800.field_40635, (class_1935)AITExtrasItems.BLACK_FEZ_HAT, (int)1).method_10435("fez").method_10439("WD").method_10434(Character.valueOf('W'), (class_1935)AITExtrasItems.WHITE_FEZ_HAT).method_10434(Character.valueOf('D'), (class_1935)class_1802.field_8226).method_10429(class_2446.method_32807((class_1935)AITExtrasItems.WHITE_FEZ_HAT), (class_184)class_2446.method_10426((class_1935)AITExtrasItems.WHITE_FEZ_HAT)));
            provider.addShapedRecipe(class_2447.method_10436((class_7800)class_7800.field_40635, (class_1935)AITExtrasItems.BLUE_FEZ_HAT, (int)1).method_10435("fez").method_10439("WD").method_10434(Character.valueOf('W'), (class_1935)AITExtrasItems.WHITE_FEZ_HAT).method_10434(Character.valueOf('D'), (class_1935)class_1802.field_8345).method_10429(class_2446.method_32807((class_1935)AITExtrasItems.WHITE_FEZ_HAT), (class_184)class_2446.method_10426((class_1935)AITExtrasItems.WHITE_FEZ_HAT)));
            provider.addShapedRecipe(class_2447.method_10436((class_7800)class_7800.field_40635, (class_1935)AITExtrasItems.BROWN_FEZ_HAT, (int)1).method_10435("fez").method_10439("WD").method_10434(Character.valueOf('W'), (class_1935)AITExtrasItems.WHITE_FEZ_HAT).method_10434(Character.valueOf('D'), (class_1935)class_1802.field_8099).method_10429(class_2446.method_32807((class_1935)AITExtrasItems.WHITE_FEZ_HAT), (class_184)class_2446.method_10426((class_1935)AITExtrasItems.WHITE_FEZ_HAT)));
            provider.addShapedRecipe(class_2447.method_10436((class_7800)class_7800.field_40635, (class_1935)AITExtrasItems.CYAN_FEZ_HAT, (int)1).method_10435("fez").method_10439("WD").method_10434(Character.valueOf('W'), (class_1935)AITExtrasItems.WHITE_FEZ_HAT).method_10434(Character.valueOf('D'), (class_1935)class_1802.field_8632).method_10429(class_2446.method_32807((class_1935)AITExtrasItems.WHITE_FEZ_HAT), (class_184)class_2446.method_10426((class_1935)AITExtrasItems.WHITE_FEZ_HAT)));
            provider.addShapedRecipe(class_2447.method_10436((class_7800)class_7800.field_40635, (class_1935)AITExtrasItems.GRAY_FEZ_HAT, (int)1).method_10435("fez").method_10439("WD").method_10434(Character.valueOf('W'), (class_1935)AITExtrasItems.WHITE_FEZ_HAT).method_10434(Character.valueOf('D'), (class_1935)class_1802.field_8298).method_10429(class_2446.method_32807((class_1935)AITExtrasItems.WHITE_FEZ_HAT), (class_184)class_2446.method_10426((class_1935)AITExtrasItems.WHITE_FEZ_HAT)));
            provider.addShapedRecipe(class_2447.method_10436((class_7800)class_7800.field_40635, (class_1935)AITExtrasItems.GREEN_FEZ_HAT, (int)1).method_10435("fez").method_10439("WD").method_10434(Character.valueOf('W'), (class_1935)AITExtrasItems.WHITE_FEZ_HAT).method_10434(Character.valueOf('D'), (class_1935)class_1802.field_8408).method_10429(class_2446.method_32807((class_1935)AITExtrasItems.WHITE_FEZ_HAT), (class_184)class_2446.method_10426((class_1935)AITExtrasItems.WHITE_FEZ_HAT)));
            provider.addShapedRecipe(class_2447.method_10436((class_7800)class_7800.field_40635, (class_1935)AITExtrasItems.LIGHT_BLUE_FEZ_HAT, (int)1).method_10435("fez").method_10439("WD").method_10434(Character.valueOf('W'), (class_1935)AITExtrasItems.WHITE_FEZ_HAT).method_10434(Character.valueOf('D'), (class_1935)class_1802.field_8273).method_10429(class_2446.method_32807((class_1935)AITExtrasItems.WHITE_FEZ_HAT), (class_184)class_2446.method_10426((class_1935)AITExtrasItems.WHITE_FEZ_HAT)));
            provider.addShapedRecipe(class_2447.method_10436((class_7800)class_7800.field_40635, (class_1935)AITExtrasItems.LIGHT_GRAY_FEZ_HAT, (int)1).method_10435("fez").method_10439("WD").method_10434(Character.valueOf('W'), (class_1935)AITExtrasItems.WHITE_FEZ_HAT).method_10434(Character.valueOf('D'), (class_1935)class_1802.field_8851).method_10429(class_2446.method_32807((class_1935)AITExtrasItems.WHITE_FEZ_HAT), (class_184)class_2446.method_10426((class_1935)AITExtrasItems.WHITE_FEZ_HAT)));
            provider.addShapedRecipe(class_2447.method_10436((class_7800)class_7800.field_40635, (class_1935)AITExtrasItems.LIME_FEZ_HAT, (int)1).method_10435("fez").method_10439("WD").method_10434(Character.valueOf('W'), (class_1935)AITExtrasItems.WHITE_FEZ_HAT).method_10434(Character.valueOf('D'), (class_1935)class_1802.field_8131).method_10429(class_2446.method_32807((class_1935)AITExtrasItems.WHITE_FEZ_HAT), (class_184)class_2446.method_10426((class_1935)AITExtrasItems.WHITE_FEZ_HAT)));
            provider.addShapedRecipe(class_2447.method_10436((class_7800)class_7800.field_40635, (class_1935)AITExtrasItems.MAGENTA_FEZ_HAT, (int)1).method_10435("fez").method_10439("WD").method_10434(Character.valueOf('W'), (class_1935)AITExtrasItems.WHITE_FEZ_HAT).method_10434(Character.valueOf('D'), (class_1935)class_1802.field_8669).method_10429(class_2446.method_32807((class_1935)AITExtrasItems.WHITE_FEZ_HAT), (class_184)class_2446.method_10426((class_1935)AITExtrasItems.WHITE_FEZ_HAT)));
            provider.addShapedRecipe(class_2447.method_10436((class_7800)class_7800.field_40635, (class_1935)AITExtrasItems.ORANGE_FEZ_HAT, (int)1).method_10435("fez").method_10439("WD").method_10434(Character.valueOf('W'), (class_1935)AITExtrasItems.WHITE_FEZ_HAT).method_10434(Character.valueOf('D'), (class_1935)class_1802.field_8492).method_10429(class_2446.method_32807((class_1935)AITExtrasItems.WHITE_FEZ_HAT), (class_184)class_2446.method_10426((class_1935)AITExtrasItems.WHITE_FEZ_HAT)));
            provider.addShapedRecipe(class_2447.method_10436((class_7800)class_7800.field_40635, (class_1935)AITExtrasItems.PINK_FEZ_HAT, (int)1).method_10435("fez").method_10439("WD").method_10434(Character.valueOf('W'), (class_1935)AITExtrasItems.WHITE_FEZ_HAT).method_10434(Character.valueOf('D'), (class_1935)class_1802.field_8330).method_10429(class_2446.method_32807((class_1935)AITExtrasItems.WHITE_FEZ_HAT), (class_184)class_2446.method_10426((class_1935)AITExtrasItems.WHITE_FEZ_HAT)));
            provider.addShapedRecipe(class_2447.method_10436((class_7800)class_7800.field_40635, (class_1935)AITExtrasItems.PURPLE_FEZ_HAT, (int)1).method_10435("fez").method_10439("WD").method_10434(Character.valueOf('W'), (class_1935)AITExtrasItems.WHITE_FEZ_HAT).method_10434(Character.valueOf('D'), (class_1935)class_1802.field_8296).method_10429(class_2446.method_32807((class_1935)AITExtrasItems.WHITE_FEZ_HAT), (class_184)class_2446.method_10426((class_1935)AITExtrasItems.WHITE_FEZ_HAT)));
            provider.addShapedRecipe(class_2447.method_10436((class_7800)class_7800.field_40635, (class_1935)AITExtrasItems.RED_FEZ_HAT, (int)1).method_10435("fez").method_10439("WD").method_10434(Character.valueOf('W'), (class_1935)AITExtrasItems.WHITE_FEZ_HAT).method_10434(Character.valueOf('D'), (class_1935)class_1802.field_8264).method_10429(class_2446.method_32807((class_1935)AITExtrasItems.WHITE_FEZ_HAT), (class_184)class_2446.method_10426((class_1935)AITExtrasItems.WHITE_FEZ_HAT)));
            provider.addShapedRecipe(class_2447.method_10436((class_7800)class_7800.field_40635, (class_1935)AITExtrasItems.YELLOW_FEZ_HAT, (int)1).method_10435("fez").method_10439("WD").method_10434(Character.valueOf('W'), (class_1935)AITExtrasItems.WHITE_FEZ_HAT).method_10434(Character.valueOf('D'), (class_1935)class_1802.field_8192).method_10429(class_2446.method_32807((class_1935)AITExtrasItems.WHITE_FEZ_HAT), (class_184)class_2446.method_10426((class_1935)AITExtrasItems.WHITE_FEZ_HAT)));
            provider.addShapedRecipe(class_2447.method_10436((class_7800)class_7800.field_40635, (class_1935)AITExtrasItems.SCARF, (int)1).method_10435("scarf").method_10439("SSS").method_10439("S S").method_10434(Character.valueOf('S'), (class_1935)class_1802.field_8276).method_10429(class_2446.method_32807((class_1935)class_1802.field_8276), (class_184)class_2446.method_10426((class_1935)class_1802.field_8276)));
            provider.addShapedRecipe(class_2447.method_10436((class_7800)class_7800.field_40635, (class_1935)AITExtrasItems.SCARF_RED, (int)1).method_10435("scarf").method_10439("SD").method_10434(Character.valueOf('S'), (class_1935)AITExtrasItems.SCARF).method_10434(Character.valueOf('D'), (class_1935)class_1802.field_8264).method_10429(class_2446.method_32807((class_1935)AITExtrasItems.SCARF), (class_184)class_2446.method_10426((class_1935)AITExtrasItems.SCARF)));
            provider.addShapedRecipe(class_2447.method_10436((class_7800)class_7800.field_40635, (class_1935)AITExtrasItems.SCARF_RAINBOW, (int)1).method_10435("scarf").method_10439("SRB").method_10439("PYG").method_10434(Character.valueOf('S'), (class_1935)AITExtrasItems.SCARF).method_10434(Character.valueOf('R'), (class_1935)class_1802.field_8264).method_10434(Character.valueOf('B'), (class_1935)class_1802.field_8345).method_10434(Character.valueOf('P'), (class_1935)class_1802.field_8296).method_10434(Character.valueOf('Y'), (class_1935)class_1802.field_8192).method_10434(Character.valueOf('G'), (class_1935)class_1802.field_8408).method_10429(class_2446.method_32807((class_1935)AITExtrasItems.SCARF), (class_184)class_2446.method_10426((class_1935)AITExtrasItems.SCARF)));
            provider.addShapedRecipe(class_2447.method_10436((class_7800)class_7800.field_40635, (class_1935)AITExtrasItems.TENNANT_COAT, (int)1).method_10439("L L").method_10439("LLL").method_10434(Character.valueOf('L'), (class_1935)class_1802.field_8745).method_10429(class_2446.method_32807((class_1935)class_1802.field_8745), (class_184)class_2446.method_10426((class_1935)class_1802.field_8745)));
            provider.addShapedRecipe(class_2447.method_10436((class_7800)class_7800.field_40635, (class_1935)AITExtrasItems.THREED_GLASSES, (int)1).method_10439("  R").method_10439(" W ").method_10439("B  ").method_10434(Character.valueOf('W'), (class_1935)class_1802.field_19044).method_10434(Character.valueOf('B'), (class_1935)class_2246.field_10060).method_10434(Character.valueOf('R'), (class_1935)class_2246.field_10272).method_10429(class_2446.method_32807((class_1935)class_1802.field_19044), (class_184)class_2446.method_10426((class_1935)class_1802.field_19044)).method_10429(class_2446.method_32807((class_1935)class_2246.field_10060), (class_184)class_2446.method_10426((class_1935)class_2246.field_10060)).method_10429(class_2446.method_32807((class_1935)class_2246.field_10272), (class_184)class_2446.method_10426((class_1935)class_2246.field_10272)));
            return provider;
        });
    }

    private void genLang(FabricDataGenerator.Pack pack) {
        this.genEnglish(pack);
    }

    private void genEnglish(FabricDataGenerator.Pack pack) {
        pack.addProvider((output, registriesFuture) -> {
            AmbleLanguageProvider provider = new AmbleLanguageProvider(output, LanguageType.EN_US);
            provider.translateBlocks(AITBlocks.class);
            provider.addTranslation("desktop.ait-extras.axos", "Axos");
            provider.addTranslation("desktop.ait-extras.cherryblossom", "CherryBlossom");
            provider.addTranslation("desktop.ait-extras.definitive", "Definitive");
            provider.addTranslation("desktop.ait-extras.exile", "Exile");
            provider.addTranslation("desktop.ait-extras.industrial", "Industrial");
            provider.addTranslation("desktop.ait-extras.tron", "Tron");
            provider.addTranslation("desktop.ait-extras.war_games", "War Games");
            provider.addTranslation("desktop.ait-extras.academic", "Academic");
            provider.addTranslation("desktop.ait-extras.rebel", "Rebel");
            provider.addTranslation("desktop.ait-extras.undercroft", "Undercroft");
            provider.addTranslation("desktop.ait-extras.tardim", "Tardim");
            provider.addTranslation("desktop.ait-extras.type_85", "Type 85");
            provider.addTranslation("desktop.ait-extras.type_89", "Type 89");
            provider.addTranslation("desktop.ait-extras.wooden", "Wooden");
            provider.addTranslation("desktop.ait-extras.human_nature", "Human Nature Remixed");
            provider.addTranslation("exterior.ait-extras.bookshelf_birch", "Bookshelf (Birch)");
            provider.addTranslation("exterior.ait-extras.bookshelf_cherry", "Bookshelf (Cherry)");
            provider.addTranslation("exterior.ait-extras.bookshelf_dark_oak", "Bookshelf (Dark Oak)");
            provider.addTranslation("exterior.ait-extras.bookshelf_jungle", "Bookshelf (Jungle)");
            provider.addTranslation("exterior.ait-extras.bookshelf_mangrove", "Bookshelf (Mangrove)");
            provider.addTranslation("exterior.ait-extras.bookshelf_oak", "Bookshelf (Oak)");
            provider.addTranslation("exterior.ait-extras.bookshelf_spruce", "Bookshelf (Spruce)");
            provider.addTranslation("exterior.ait-extras.aperture_science", "Aperture");
            provider.addTranslation("exterior.ait-extras.black_mesa", "Mesa");
            provider.addTranslation("exterior.ait-extras.copper", "Copper");
            provider.addTranslation("exterior.ait-extras.eleven_toyota", "Copper Toyota");
            provider.addTranslation("exterior.ait-extras.eleven_toyota_alternate", "Copper Toyota (ALT)");
            provider.addTranslation("exterior.ait-extras.coral_alternate", "Coral (ALT)");
            provider.addTranslation("exterior.ait-extras.tokamak_eotd", "Tokamak (EOTD)");
            provider.addTranslation("exterior.ait-extras.toyota_alternate", "Toyota (ALT)");
            provider.addTranslation("exterior.ait-extras.tokamak", "Crystalline");
            provider.addTranslation("exterior.ait-extras.yard", "73 Yards");
            provider.addTranslation("exterior.ait-extras.60thmc", "60th Musical Celebration");
            provider.addTranslation("exterior.ait-extras.tango", "Tango");
            provider.addTranslation("exterior.ait-extras.classic_cricketer", "Cricketer");
            provider.addTranslation("exterior.ait-extras.classic_cricketer2", "Cricketer (ALT)");
            provider.addTranslation("exterior.ait-extras.classic_happiness", "Happiness");
            provider.addTranslation("exterior.ait-extras.classic_pilot", "Pilot");
            provider.addTranslation("exterior.ait-extras.classic_precedent", "Precedent");
            provider.addTranslation("exterior.ait-extras.classic_snowman", "Snowman");
            provider.addTranslation("exterior.ait-extras.classic_victorian", "Victorian");
            provider.addTranslation("exterior.ait-extras.classic_wanderlust", "Wanderlust");
            provider.addTranslation("exterior.ait-extras.tinylink", "Tiny Link");
            provider.addTranslation("exterior.ait-extras.ecto", "Ecto");
            provider.addTranslation("exterior.ait-extras.post_box", "Post Box");
            provider.addTranslation("exterior.ait-extras.vanilla", "Vanilla");
            provider.addTranslation("exterior.ait-extras.vanilla_red", "Vanilla (Glasgow)");
            provider.addTranslation("exterior.ait-extras.vanilla_beacon", "Vanilla (Beacon)");
            provider.addTranslation("exterior.ait-extras.vanilla_wooden", "Vanilla (Wooden)");
            provider.addTranslation("exterior.ait-extras.vanilla_classic", "Vanilla (Classic)");
            provider.addTranslation("exterior.ait-extras.vanilla_classic_wooden", "Vanilla (Classic Wooden)");
            provider.addTranslation("exterior.ait-extras.clock", "Clock");
            provider.addTranslation("exterior.ait-extras.clock_master", "Clock (Master)");
            provider.addTranslation("exterior.ait-extras.origin", "Origin");
            provider.addTranslation("exterior.ait-extras.origin_red", "Origin (Ruin)");
            provider.addTranslation("exterior.ait-extras.origin_soul", "Origin (Soul)");
            provider.addTranslation("exterior.ait-extras.origin_fire", "Origin (Fire)");
            provider.addTranslation("sonic.ait-extras.cane", "Cane");
            provider.addTranslation("sonic.ait-extras.fob_pink", "Fob (Pink)");
            provider.addTranslation("sonic.ait-extras.fob_red", "Fob (Red)");
            provider.addTranslation("sonic.ait-extras.fob_yellow", "Fob (Yellow)");
            provider.addTranslation("sonic.ait-extras.pertwee", "Pertwee");
            provider.addTranslation("sonic.ait-extras.baker", "Baker");
            provider.addTranslation("sonic.ait-extras.retro", "Retro");
            provider.addTranslation("sonic.ait-extras.mcgann", "McGann");
            provider.addTranslation("sonic.ait-extras.troughton", "Troughton");
            provider.addTranslation(AITExtrasBlocks.EXTRAS_MONITOR_BLOCK, "Victorian Monitor");
            provider.addTranslation(AITExtrasBlocks.EXTRAS_SCREEN_MONITOR_BLOCK, "Screen (3x2)");
            provider.addTranslation(AITExtrasBlocks.CRYSTALLINE_SHARD_BLOCK, "Crystalline Shard Block");
            provider.addTranslation(AITExtrasBlocks.CRYSTALLINE_ORE, "Crystalline Ore");
            provider.addTranslation(AITExtrasBlocks.SUN_DIAL_BLOCK, "Armillary Sphere");
            provider.addTranslation(AITExtrasBlocks.HAT_STAND_ACACIA_BLOCK, "Hat Stand");
            provider.addTranslation(AITExtrasBlocks.HAT_STAND_BAMBOO_BLOCK, "Hat Stand");
            provider.addTranslation(AITExtrasBlocks.HAT_STAND_BIRCH_BLOCK, "Hat Stand");
            provider.addTranslation(AITExtrasBlocks.HAT_STAND_CHERRY_BLOCK, "Hat Stand");
            provider.addTranslation(AITExtrasBlocks.HAT_STAND_CRIMSON_BLOCK, "Hat Stand");
            provider.addTranslation(AITExtrasBlocks.HAT_STAND_DARK_OAK_BLOCK, "Hat Stand");
            provider.addTranslation(AITExtrasBlocks.HAT_STAND_JUNGLE_BLOCK, "Hat Stand");
            provider.addTranslation(AITExtrasBlocks.HAT_STAND_MANGROVE_BLOCK, "Hat Stand");
            provider.addTranslation(AITExtrasBlocks.HAT_STAND_OAK_BLOCK, "Hat Stand");
            provider.addTranslation(AITExtrasBlocks.HAT_STAND_SPRUCE_BLOCK, "Hat Stand");
            provider.addTranslation(AITExtrasBlocks.HAT_STAND_WARPED_BLOCK, "Hat Stand");
            provider.addTranslation(AITExtrasBlocks.CRYSTAL_BLOCK, "Roof Crystal");
            provider.addTranslation(AITExtrasBlocks.CRYSTAL_ZEITON_BLOCK, "Roof Crystal (Zeiton)");
            provider.addTranslation(AITExtrasBlocks.CRYSTAL_MASTER_BLOCK, "Roof Crystal (Master)");
            provider.addTranslation(AITExtrasBlocks.HUDOLIN_SUPPORT_BASE_BLOCK, "Hudolin Support (Base)");
            provider.addTranslation(AITExtrasBlocks.HUDOLIN_SUPPORT_TOP_BLOCK, "Hudolin Support (Top)");
            provider.addTranslation(AITExtrasBlocks.POLISHED_COMPACT_ZEITON, "Polished Compact Zeiton");
            provider.addTranslation(AITExtrasBlocks.POLISHED_COMPACT_ZEITON_SLAB, "Polished Compact Zeiton Slab");
            provider.addTranslation(AITExtrasBlocks.POLISHED_COMPACT_ZEITON_STAIRS, "Polished Compact Zeiton Stairs");
            provider.addTranslation(AITExtrasBlocks.POLISHED_COMPACT_ZEITON_WALL, "Polished Compact Zeiton Wall");
            provider.addTranslation(AITExtrasBlocks.COMPACT_ZEITON_BRICKS, "Compact Zeiton Bricks");
            provider.addTranslation(AITExtrasBlocks.COMPACT_ZEITON_BRICK_WALL, "Compact Zeiton Brick Wall");
            provider.addTranslation(AITExtrasBlocks.COMPACT_ZEITON_BRICK_STAIRS, "Compact Zeiton Brick Stairs");
            provider.addTranslation(AITExtrasBlocks.COMPACT_ZEITON_BRICK_SLAB, "Compact Zeiton Brick Slab");
            provider.addTranslation(AITExtrasBlocks.ZIRCONIUM_ORE, "Zirconium Ore");
            provider.addTranslation(AITExtrasBlocks.SEAL_BLOCK, "Seal Of Rassilon");
            provider.addTranslation(AITExtrasBlocks.SEAL_SMALL_BLOCK, "Seal Of Rassilon (Small)");
            provider.addTranslation(AITExtrasBlocks.CANDLE_STAND_LARGE_BLOCK, "Candle Stand (Large)");
            provider.addTranslation(AITExtrasBlocks.CANDLE_STAND_SINGLE_BLOCK, "Candle Stand (Single)");
            provider.addTranslation(AITExtrasBlocks.CANDLE_STAND_SMALL_BLOCK, "Candle Stand (Small)");
            provider.addTranslation(AITExtrasBlocks.METAL_GRATE, "Metal Grate");
            provider.addTranslation(AITExtrasBlocks.METAL_GRATE_SLAB, "Metal Grate Slab");
            provider.addTranslation(AITExtrasBlocks.METAL_GRATE_STAIRS, "Metal Grate Stairs");
            provider.addTranslation(AITExtrasBlocks.METAL_GRATE_WALL, "Metal Grate Wall");
            provider.addTranslation(AITExtrasBlocks.METAL_GRATE_TRAPDOOR, "Metal Grate Trapdoor");
            provider.addTranslation(AITExtrasBlocks.METAL_MESH, "Metal Mesh");
            provider.addTranslation(AITExtrasBlocks.METAL_MESH_SLAB, "Metal Mesh Slab");
            provider.addTranslation(AITExtrasBlocks.METAL_MESH_STAIRS, "Metal Mesh Stairs");
            provider.addTranslation(AITExtrasBlocks.METAL_MESH_WALL, "Metal Mesh Wall");
            provider.addTranslation(AITExtrasBlocks.METAL_MESH_TRAPDOOR, "Metal Mesh Trapdoor");
            provider.addTranslation(AITExtrasBlocks.ARS_EGG_BLOCK, "ARS Egg");
            provider.addTranslation(AITExtrasItems.MERCURY_DISC.method_7876() + ".desc", "Nitrogenez - Mercury");
            provider.addTranslation(AITExtrasItems.MERCURY_DISC, "Music Disc");
            provider.addTranslation(AITExtrasItems.JELLY_BABIES, "Jelly Babies");
            provider.addTranslation(AITExtrasItems.CUSTARD_CREAM, "Custard Cream");
            provider.addTranslation(AITExtrasItems.RICE_PUDDING, "Rice Pudding");
            provider.addTranslation(AITExtrasItems.CRYSTALLINE_SHARD, "Crystalline Shard");
            provider.addTranslation(AITExtrasItems.RAW_ZIRCONIUM, "Raw Zirconium");
            provider.addTranslation(AITExtrasItems.ZIRCONIUM_INGOT, "Zirconium Ingot");
            provider.addTranslation(AITExtrasItems.WHISTLE, "Summon Whistle");
            provider.addTranslation(AITExtrasItems.ATOMIC_SHREDDER, "Atomic Shredder");
            provider.addTranslation(AITExtrasItems.METAL_MESH_ITEM, "Metal Mesh");
            provider.addTranslation(AITExtrasItems.METAL_GRATE_ITEM, "Metal Grate");
            provider.addTranslation(AITExtrasItems.JELLY_BABIES, "Jelly Babies");
            provider.addTranslation(AITExtrasItems.CUSTARD_CREAM, "Custard Cream");
            provider.addTranslation(AITExtrasItems.RICE_PUDDING, "Rice Pudding");
            provider.addTranslation(AITExtrasItems.CRYSTALLINE_SHARD, "Crystalline Shard");
            provider.addTranslation(AITExtrasItems.RAW_ZIRCONIUM, "Raw Zirconium");
            provider.addTranslation(AITExtrasItems.ZIRCONIUM_INGOT, "Zirconium Ingot");
            provider.addTranslation(AITExtrasItems.WHISTLE, "Summon Whistle");
            provider.addTranslation(AITExtrasItems.ATOMIC_SHREDDER, "Atomic Shredder");
            provider.addTranslation(AITExtrasItems.METAL_GRATE_ITEM, "Metal Grate");
            provider.addTranslation(AITExtrasItems.METAL_MESH_ITEM, "Metal Mesh");
            provider.addTranslation(AITExtrasItems.WHITE_FEZ_HAT, "White Fez");
            provider.addTranslation(AITExtrasItems.BLACK_FEZ_HAT, "Black Fez");
            provider.addTranslation(AITExtrasItems.BLUE_FEZ_HAT, "Blue Fez");
            provider.addTranslation(AITExtrasItems.BROWN_FEZ_HAT, "Brown Fez");
            provider.addTranslation(AITExtrasItems.CYAN_FEZ_HAT, "Cyan Fez");
            provider.addTranslation(AITExtrasItems.GRAY_FEZ_HAT, "Gray Fez");
            provider.addTranslation(AITExtrasItems.GREEN_FEZ_HAT, "Green Fez");
            provider.addTranslation(AITExtrasItems.LIGHT_BLUE_FEZ_HAT, "Light Blue Fez");
            provider.addTranslation(AITExtrasItems.LIGHT_GRAY_FEZ_HAT, "Light Gray Fez");
            provider.addTranslation(AITExtrasItems.LIME_FEZ_HAT, "Lime Fez");
            provider.addTranslation(AITExtrasItems.MAGENTA_FEZ_HAT, "Magenta Fez");
            provider.addTranslation(AITExtrasItems.ORANGE_FEZ_HAT, "Orange Fez");
            provider.addTranslation(AITExtrasItems.PINK_FEZ_HAT, "Pink Fez");
            provider.addTranslation(AITExtrasItems.PURPLE_FEZ_HAT, "Purple Fez");
            provider.addTranslation(AITExtrasItems.RED_FEZ_HAT, "Red Fez");
            provider.addTranslation(AITExtrasItems.YELLOW_FEZ_HAT, "Yellow Fez");
            provider.addTranslation(AITExtrasItems.SCARF, "Scarf");
            provider.addTranslation(AITExtrasItems.SCARF_RED, "Red Scarf");
            provider.addTranslation(AITExtrasItems.SCARF_RAINBOW, "Rainbow Scarf");
            provider.addTranslation(AITExtrasItems.TENNANT_COAT, "Tennant Coat");
            provider.addTranslation(AITExtrasItems.THREED_GLASSES, "3D Glasses");
            provider.addTranslation((class_1761)AITExtrasItemGroups.MAIN, "AIT Extras");
            provider.addTranslation("itemGroup.ait-extras.item_group_cosmetics", "AIT Extras: Cosmetics");
            provider.addTranslation("block.tooltip.seal", "If you SHIFT when placing this, it will become a CENTERED version!!");
            provider.addTranslation("block.tooltip.ars_egg", "If you RIGHT CLICK the block, it will turn ON and OFF!!");
            provider.addTranslation("block.tooltip.hatstandacacia", "Variant: Acacia");
            provider.addTranslation("block.tooltip.hatstandbamboo", "Variant: Bamboo");
            provider.addTranslation("block.tooltip.hatstandbirch", "Variant: Birch");
            provider.addTranslation("block.tooltip.hatstandcherry", "Variant: Cherry");
            provider.addTranslation("block.tooltip.hatstandcrimson", "Variant: Crimson");
            provider.addTranslation("block.tooltip.hatstanddarkoak", "Variant: Dark Oak");
            provider.addTranslation("block.tooltip.hatstandjungle", "Variant: Jungle");
            provider.addTranslation("block.tooltip.hatstandmangrove", "Variant: Mangrove");
            provider.addTranslation("block.tooltip.hatstandoak", "Variant: Oak");
            provider.addTranslation("block.tooltip.hatstandspruce", "Variant: Spruce");
            provider.addTranslation("block.tooltip.hatstandwarped", "Variant: Warped");
            provider.addTranslation("animation.ait-extras.classic_mat", "Classic (Alt)");
            provider.addTranslation("animation.ait-extras.classic_demat", "Classic (Alt)");
            provider.addTranslation("animation.ait-extras.drumless_demat", "Drumless");
            provider.addTranslation("animation.ait-extras.fast_mat", "Fast");
            provider.addTranslation("animation.ait-extras.fast_demat", "Fast");
            provider.addTranslation("animation.ait-extras.minecart_mat", "Minecart");
            provider.addTranslation("animation.ait-extras.minecart_demat", "Minecart");
            provider.addTranslation("animation.ait-extras.regen_demat", "Regen");
            provider.addTranslation("animation.ait-extras.type70_mat", "Type 70");
            provider.addTranslation("animation.ait-extras.type70_demat", "Type 70");
            provider.addTranslation("animation.ait-extras.xmas_demat", "Xmas");
            provider.addTranslation("achievement.ait-extras.title.root", "AIT Extras");
            provider.addTranslation("achievement.ait-extras.description.root", "Like AIT, but more!");
            provider.addTranslation("achievement.ait-extras.title.obtain_jelly_babies", "Would you like a Jelly Baby?");
            provider.addTranslation("achievement.ait-extras.description.obtain_jelly_babies", "Craft Jelly Babies");
            provider.addTranslation("achievement.ait-extras.title.obtain_extras_monitor_block", "Critical Timing Malfunction!");
            provider.addTranslation("achievement.ait-extras.description.obtain_extras_monitor_block", "Craft The Victorian Monitor");
            provider.addTranslation("achievement.ait-extras.title.obtain_custard_cream", "Yum, Yum, Yum!");
            provider.addTranslation("achievement.ait-extras.description.obtain_custard_cream", "funfact: Custard Creams are one of the best biscuits in the world!");
            provider.addTranslation("achievement.ait-extras.title.obtain_rice_pudding", "UNLIMITED RICE PUDDING!!!");
            provider.addTranslation("achievement.ait-extras.description.obtain_rice_pudding", "Powerful. Crush the lesser races. Conquer the galaxy. Unimaginable power. Unlimited rice pudding, et cetera, et cetera.");
            provider.addTranslation("achievement.ait-extras.title.obtain_seal_block", "The Seal of Rassilon!");
            provider.addTranslation("achievement.ait-extras.description.obtain_seal_block", "Craft the Seal of Rassilon");
            provider.addTranslation("achievement.ait-extras.title.obtain_ars_egg_block", "Architectural Reconfiguration System");
            provider.addTranslation("achievement.ait-extras.description.obtain_ars_egg_block", "Craft an ARS Egg");
            return provider;
        });
    }
}

