/*
 * Decompiled with CFR 0.152.
 */
package com.addie.datagen;

import com.addie.core.StargateNetworkBlocks;
import com.addie.core.StargateNetworkItems;
import com.addie.datagen.providers.StargateNetworkItemTagProvider;
import com.addie.datagen.providers.StargateNetworkModelGen;
import com.addie.datagen.providers.StargateNetworkRecipeProvider;
import dev.amble.lib.datagen.lang.AmbleLanguageProvider;
import dev.amble.lib.datagen.lang.LanguageType;
import dev.amble.lib.datagen.loot.AmbleBlockLootTable;
import dev.amble.lib.datagen.sound.AmbleSoundProvider;
import dev.amble.lib.datagen.tag.AmbleBlockTagProvider;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.datagen.v1.DataGeneratorEntrypoint;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.minecraft.class_1802;
import net.minecraft.class_184;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2446;
import net.minecraft.class_2447;
import net.minecraft.class_2450;
import net.minecraft.class_2454;
import net.minecraft.class_2960;
import net.minecraft.class_7800;

@Environment(value=EnvType.CLIENT)
public class StargateNetworkDataGenerator
implements DataGeneratorEntrypoint {
    public void onInitializeDataGenerator(FabricDataGenerator gen) {
        FabricDataGenerator.Pack pack = gen.createPack();
        this.genLang(pack);
        this.generateRecipes(pack);
        this.genLoot(pack);
        this.genTags(pack);
        this.genModels(pack);
        this.generateItemTags(pack);
        this.generateSoundData(pack);
    }

    private void genModels(FabricDataGenerator.Pack pack) {
        pack.addProvider((output, registriesFuture) -> {
            StargateNetworkModelGen provider = new StargateNetworkModelGen(output);
            provider.withBlocks(new Class[]{StargateNetworkBlocks.class});
            provider.withItems(new Class[]{StargateNetworkItems.class});
            return provider;
        });
    }

    public void generateSoundData(FabricDataGenerator.Pack pack) {
        pack.addProvider((output, registriesFuture) -> new AmbleSoundProvider(output));
    }

    public void generateItemTags(FabricDataGenerator.Pack pack) {
        pack.addProvider(StargateNetworkItemTagProvider::new);
    }

    private void genLang(FabricDataGenerator.Pack pack) {
        this.genEnglish(pack);
    }

    private void genTags(FabricDataGenerator.Pack pack) {
        pack.addProvider((output, registriesFuture) -> new AmbleBlockTagProvider(output, registriesFuture).withBlocks(new Class[]{StargateNetworkBlocks.class}));
    }

    private void genLoot(FabricDataGenerator.Pack pack) {
        pack.addProvider((output, registriesFuture) -> new AmbleBlockLootTable(output).withBlocks(new Class[]{StargateNetworkBlocks.class}));
    }

    public void generateRecipes(FabricDataGenerator.Pack pack) {
        pack.addProvider((output, registriesFuture) -> {
            StargateNetworkRecipeProvider provider = new StargateNetworkRecipeProvider(output);
            provider.addShapedRecipe(class_2447.method_10436((class_7800)class_7800.field_40635, (class_1935)StargateNetworkBlocks.TERMINAL_BLOCK, (int)1).method_10439("BII").method_10439("RII").method_10439("CRI").method_10434(Character.valueOf('I'), (class_1935)StargateNetworkItems.STEEL_INGOT).method_10434(Character.valueOf('R'), (class_1935)class_1802.field_8725).method_10434(Character.valueOf('B'), (class_1935)class_2246.field_10458).method_10434(Character.valueOf('C'), (class_1935)class_2246.field_10377).method_10429(class_2446.method_32807((class_1935)StargateNetworkItems.STEEL_INGOT), (class_184)class_2446.method_10426((class_1935)StargateNetworkItems.STEEL_INGOT)).method_10429(class_2446.method_32807((class_1935)class_1802.field_8725), (class_184)class_2446.method_10426((class_1935)class_1802.field_8725)).method_10429(class_2446.method_32807((class_1935)class_2246.field_10458), (class_184)class_2446.method_10426((class_1935)class_2246.field_10458)).method_10429(class_2446.method_32807((class_1935)class_2246.field_10377), (class_184)class_2446.method_10426((class_1935)class_2246.field_10377)));
            provider.addShapedRecipe(class_2447.method_10436((class_7800)class_7800.field_40636, (class_1935)StargateNetworkBlocks.LIGHT_BLOCK, (int)1).method_10439("R").method_10439("I").method_10434(Character.valueOf('I'), (class_1935)StargateNetworkItems.STEEL_INGOT).method_10434(Character.valueOf('R'), (class_1935)class_2246.field_10524).method_10429(class_2446.method_32807((class_1935)class_2246.field_10524), (class_184)class_2446.method_10426((class_1935)class_2246.field_10524)).method_10429(class_2446.method_32807((class_1935)StargateNetworkItems.STEEL_INGOT), (class_184)class_2446.method_10426((class_1935)StargateNetworkItems.STEEL_INGOT)));
            provider.addShapedRecipe(class_2447.method_10436((class_7800)class_7800.field_40635, (class_1935)StargateNetworkBlocks.FANCY_LIGHT_BLOCK, (int)1).method_10435("lights").method_10439("I I").method_10439("BIB").method_10439("F F").method_10434(Character.valueOf('I'), (class_1935)StargateNetworkItems.STEEL_INGOT).method_10434(Character.valueOf('B'), (class_1935)StargateNetworkBlocks.STEEL_BLOCK).method_10434(Character.valueOf('F'), (class_1935)class_2246.field_37572).method_10429(class_2446.method_32807((class_1935)class_2246.field_37572), (class_184)class_2446.method_10426((class_1935)class_2246.field_37572)).method_10429(class_2446.method_32807((class_1935)StargateNetworkItems.STEEL_INGOT), (class_184)class_2446.method_10426((class_1935)StargateNetworkItems.STEEL_INGOT)).method_10429(class_2446.method_32807((class_1935)StargateNetworkBlocks.STEEL_BLOCK), (class_184)class_2446.method_10426((class_1935)StargateNetworkBlocks.STEEL_BLOCK)));
            provider.addShapedRecipe(class_2447.method_10436((class_7800)class_7800.field_40635, (class_1935)StargateNetworkBlocks.LONG_FANCY_LIGHT_BLOCK, (int)1).method_10435("lights").method_10439("FFF").method_10434(Character.valueOf('F'), (class_1935)StargateNetworkBlocks.FANCY_LIGHT_BLOCK).method_10429(class_2446.method_32807((class_1935)StargateNetworkBlocks.FANCY_LIGHT_BLOCK), (class_184)class_2446.method_10426((class_1935)StargateNetworkBlocks.FANCY_LIGHT_BLOCK)));
            provider.addShapedRecipe(class_2447.method_10436((class_7800)class_7800.field_40635, (class_1935)StargateNetworkBlocks.WALL_LIGHT_BLOCK, (int)1).method_10435("lights").method_10439("SS ").method_10439("FFS").method_10434(Character.valueOf('F'), (class_1935)class_2246.field_37572).method_10434(Character.valueOf('S'), (class_1935)class_2246.field_28894).method_10429(class_2446.method_32807((class_1935)class_2246.field_37572), (class_184)class_2446.method_10426((class_1935)class_2246.field_37572)).method_10429(class_2446.method_32807((class_1935)class_2246.field_28894), (class_184)class_2446.method_10426((class_1935)class_2246.field_28894)));
            provider.addShapedRecipe(class_2447.method_10436((class_7800)class_7800.field_40635, (class_1935)StargateNetworkBlocks.FLOOD_LIGHT_BLOCK, (int)1).method_10435("lights").method_10439("T T").method_10439("III").method_10434(Character.valueOf('I'), (class_1935)StargateNetworkItems.STEEL_INGOT).method_10434(Character.valueOf('T'), (class_1935)class_2246.field_10336).method_10429(class_2446.method_32807((class_1935)StargateNetworkItems.STEEL_INGOT), (class_184)class_2446.method_10426((class_1935)StargateNetworkItems.STEEL_INGOT)).method_10429(class_2446.method_32807((class_1935)class_2246.field_10336), (class_184)class_2446.method_10426((class_1935)class_2246.field_10336)));
            provider.addStonecutting(class_2246.field_10542, StargateNetworkBlocks.CAUTION_BLOCK, 1);
            provider.addBlastFurnaceRecipe(class_2454.method_10473((class_1856)class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_33400}), (class_7800)class_7800.field_40642, (class_1935)StargateNetworkItems.RAW_STEEL, (float)0.2f, (int)200).method_10469(class_2446.method_32807((class_1935)class_1802.field_33400), (class_184)class_2446.method_10426((class_1935)class_1802.field_33400)));
            provider.addBlastFurnaceRecipe(class_2454.method_10473((class_1856)class_1856.method_8091((class_1935[])new class_1935[]{StargateNetworkItems.RAW_STEEL}), (class_7800)class_7800.field_40642, (class_1935)StargateNetworkItems.STEEL_INGOT, (float)0.2f, (int)200).method_10469(class_2446.method_32807((class_1935)StargateNetworkItems.RAW_STEEL), (class_184)class_2446.method_10426((class_1935)StargateNetworkItems.RAW_STEEL)));
            class_2450.method_10448((class_7800)class_7800.field_40642, (class_1935)StargateNetworkItems.STEEL_NUGGET, (int)9);
            provider.addShapelessRecipe(class_2450.method_10448((class_7800)class_7800.field_40642, (class_1935)StargateNetworkItems.STEEL_NUGGET, (int)9).method_10452("steel").method_10454((class_1935)StargateNetworkItems.STEEL_INGOT).method_10442(class_2446.method_32807((class_1935)StargateNetworkItems.STEEL_INGOT), (class_184)class_2446.method_10426((class_1935)StargateNetworkItems.STEEL_INGOT)), new class_2960("stargate-network", "steel_nugget_from_ingot"));
            class_2450.method_10448((class_7800)class_7800.field_40642, (class_1935)StargateNetworkItems.STEEL_INGOT, (int)9);
            provider.addShapelessRecipe(class_2450.method_10448((class_7800)class_7800.field_40642, (class_1935)StargateNetworkItems.STEEL_INGOT, (int)9).method_10452("steel").method_10454((class_1935)StargateNetworkBlocks.STEEL_BLOCK).method_10442(class_2446.method_32807((class_1935)StargateNetworkBlocks.STEEL_BLOCK), (class_184)class_2446.method_10426((class_1935)StargateNetworkBlocks.STEEL_BLOCK)), new class_2960("stargate-network", "steel_ingot_from_steel_block"));
            provider.addShapedRecipe(class_2447.method_10436((class_7800)class_7800.field_40642, (class_1935)StargateNetworkBlocks.STEEL_BLOCK, (int)1).method_10435("steel").method_10439("III").method_10439("III").method_10439("III").method_10434(Character.valueOf('I'), (class_1935)StargateNetworkItems.STEEL_INGOT).method_10429(class_2446.method_32807((class_1935)StargateNetworkItems.STEEL_INGOT), (class_184)class_2446.method_10426((class_1935)StargateNetworkItems.STEEL_INGOT)));
            provider.addShapedRecipe(class_2447.method_10436((class_7800)class_7800.field_40642, (class_1935)StargateNetworkItems.STEEL_INGOT, (int)1).method_10435("steel").method_10439("NNN").method_10439("NNN").method_10439("NNN").method_10434(Character.valueOf('N'), (class_1935)StargateNetworkItems.STEEL_NUGGET).method_10429(class_2446.method_32807((class_1935)StargateNetworkItems.STEEL_NUGGET), (class_184)class_2446.method_10426((class_1935)StargateNetworkItems.STEEL_NUGGET)), new class_2960("stargate-network", "steel_ingot_from_steel_nuggets"));
            provider.addShapedRecipe(class_2447.method_10436((class_7800)class_7800.field_40635, (class_1935)StargateNetworkBlocks.STEEL_SLAB_BLOCK, (int)1).method_10435("steel").method_10439("III").method_10434(Character.valueOf('I'), (class_1935)StargateNetworkItems.STEEL_INGOT).method_10429(class_2446.method_32807((class_1935)StargateNetworkItems.STEEL_INGOT), (class_184)class_2446.method_10426((class_1935)StargateNetworkItems.STEEL_INGOT)));
            provider.addShapedRecipe(class_2447.method_10436((class_7800)class_7800.field_40635, (class_1935)StargateNetworkBlocks.STEEL_STAIRS_BLOCK, (int)1).method_10435("steel").method_10439("I  ").method_10439("II ").method_10439("III").method_10434(Character.valueOf('I'), (class_1935)StargateNetworkItems.STEEL_INGOT).method_10429(class_2446.method_32807((class_1935)StargateNetworkItems.STEEL_INGOT), (class_184)class_2446.method_10426((class_1935)StargateNetworkItems.STEEL_INGOT)));
            provider.addShapedRecipe(class_2447.method_10436((class_7800)class_7800.field_40635, (class_1935)StargateNetworkBlocks.STEEL_RAILING_BLOCK, (int)1).method_10435("steel").method_10439("III").method_10439("N N").method_10434(Character.valueOf('I'), (class_1935)StargateNetworkItems.STEEL_INGOT).method_10434(Character.valueOf('N'), (class_1935)StargateNetworkItems.STEEL_NUGGET).method_10429(class_2446.method_32807((class_1935)StargateNetworkItems.STEEL_INGOT), (class_184)class_2446.method_10426((class_1935)StargateNetworkItems.STEEL_INGOT)).method_10429(class_2446.method_32807((class_1935)StargateNetworkItems.STEEL_NUGGET), (class_184)class_2446.method_10426((class_1935)StargateNetworkItems.STEEL_NUGGET)));
            provider.addShapedRecipe(class_2447.method_10436((class_7800)class_7800.field_40635, (class_1935)StargateNetworkBlocks.SLANTED_STEEL_RAILING_BLOCK, (int)1).method_10435("steel").method_10439("I  ").method_10439("NII").method_10439("  N").method_10434(Character.valueOf('I'), (class_1935)StargateNetworkItems.STEEL_INGOT).method_10434(Character.valueOf('N'), (class_1935)StargateNetworkItems.STEEL_NUGGET).method_10429(class_2446.method_32807((class_1935)StargateNetworkItems.STEEL_INGOT), (class_184)class_2446.method_10426((class_1935)StargateNetworkItems.STEEL_INGOT)).method_10429(class_2446.method_32807((class_1935)StargateNetworkItems.STEEL_NUGGET), (class_184)class_2446.method_10426((class_1935)StargateNetworkItems.STEEL_NUGGET)));
            provider.addShapedRecipe(class_2447.method_10436((class_7800)class_7800.field_40635, (class_1935)StargateNetworkBlocks.GRATED_STEEL_STAIRS_BLOCK, (int)1).method_10435("steel").method_10439("N  ").method_10439("NN ").method_10439("NNN").method_10434(Character.valueOf('N'), (class_1935)StargateNetworkItems.STEEL_NUGGET).method_10429(class_2446.method_32807((class_1935)StargateNetworkItems.STEEL_NUGGET), (class_184)class_2446.method_10426((class_1935)StargateNetworkItems.STEEL_NUGGET)));
            provider.addShapedRecipe(class_2447.method_10436((class_7800)class_7800.field_40635, (class_1935)StargateNetworkBlocks.TABLE_BLOCK, (int)2).method_10435("").method_10439("MM").method_10439("DD").method_10434(Character.valueOf('M'), (class_1935)class_2246.field_37564).method_10434(Character.valueOf('D'), (class_1935)class_2246.field_28892).method_10429(class_2446.method_32807((class_1935)class_2246.field_37564), (class_184)class_2446.method_10426((class_1935)class_2246.field_37564)).method_10429(class_2446.method_32807((class_1935)class_2246.field_28892), (class_184)class_2446.method_10426((class_1935)class_2246.field_28892)));
            return provider;
        });
    }

    private void genEnglish(FabricDataGenerator.Pack pack) {
        pack.addProvider((output, registriesFuture) -> {
            AmbleLanguageProvider provider = new AmbleLanguageProvider(output, LanguageType.EN_US);
            provider.addTranslation("itemGroup.stargate-network.tauri", "SGN: Tau'ri");
            provider.addTranslation("itemGroup.stargate-network.misc", "SGN: Misc");
            provider.addTranslation(StargateNetworkBlocks.CAUTION_BLOCK, "Caution Block");
            provider.addTranslation(StargateNetworkBlocks.TERMINAL_BLOCK, "Terminal");
            provider.addTranslation(StargateNetworkBlocks.LIGHT_BLOCK, "Emergancy Light");
            provider.addTranslation(StargateNetworkBlocks.FANCY_LIGHT_BLOCK, "Fancy Light");
            provider.addTranslation(StargateNetworkBlocks.LONG_FANCY_LIGHT_BLOCK, "Long Fancy Light");
            provider.addTranslation(StargateNetworkBlocks.WALL_LIGHT_BLOCK, "Wall Light");
            provider.addTranslation(StargateNetworkBlocks.FLOOD_LIGHT_BLOCK, "Flood Light");
            provider.addTranslation(StargateNetworkBlocks.STEEL_BLOCK, "Steel Block");
            provider.addTranslation(StargateNetworkBlocks.STEEL_STAIRS_BLOCK, "Steel Stairs");
            provider.addTranslation(StargateNetworkBlocks.STEEL_SLAB_BLOCK, "Steel Slab");
            provider.addTranslation(StargateNetworkBlocks.SLANTED_STEEL_RAILING_BLOCK, "Steel Railing (Slanted)");
            provider.addTranslation(StargateNetworkBlocks.STEEL_RAILING_BLOCK, "Steel Railing");
            provider.addTranslation(StargateNetworkBlocks.GRATED_STEEL_STAIRS_BLOCK, "Grated Steel Stairs");
            provider.addTranslation(StargateNetworkBlocks.TABLE_BLOCK, "Table");
            provider.addTranslation(StargateNetworkItems.STEEL_INGOT, "Steel Ingot");
            provider.addTranslation(StargateNetworkItems.STEEL_NUGGET, "Steel Nugget");
            provider.addTranslation(StargateNetworkItems.RAW_STEEL, "Raw Steel");
            return provider;
        });
    }
}

