package com.addie.renderers;

import com.addie.StargateNetwork;
import com.addie.core.blockentites.FancyLightBlockEntity;
import com.addie.core.blocks.FancyLightBlock;
import com.addie.models.FancyLightModel;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_7833;
import net.minecraft.class_827;

public class FancyLightRenderer<T extends FancyLightBlockEntity> implements class_827<T> {

    public static final class_2960 LIGHT_TEXTURE = new class_2960(
            StargateNetwork.MOD_ID, "textures/blockentities/fancy_lights/fancy_light.png");
    public static final class_2960 EMISSIVE_LIGHT_TEXTURE = new class_2960(
            StargateNetwork.MOD_ID, "textures/blockentities/fancy_lights/fancy_light_emission.png");

    private final FancyLightModel fancylightModel;

    public FancyLightRenderer(class_5614.class_5615 ctx) {
        this.fancylightModel = new FancyLightModel(FancyLightModel.getTexturedModelData().method_32109());
    }

    @Override
    public void render(T entity, float tickDelta, class_4587 matrices,
                       class_4597 vertexConsumers, int light, int overlay) {

        class_2680 blockState = entity.method_11010();
        if (!(blockState.method_26204() instanceof FancyLightBlock)) {
            return;
        }

        class_2350 direction = blockState.method_11654(FancyLightBlock.FACING);

        
        float rotationDegrees = switch (direction) {
            case field_11043 -> 180f;
            case field_11035 -> 0f;
            case field_11039 -> 90f;
            case field_11034 -> -90f;
            default -> 0f;
        };

        matrices.method_22903();
        matrices.method_46416(0.5f, 1.5f, 0.5f);
        matrices.method_22907(class_7833.field_40715.rotationDegrees(rotationDegrees));
        matrices.method_22907(class_7833.field_40714.rotationDegrees(180));

        float scale = entity.getScale();
        matrices.method_22905(scale, scale, scale);


        this.fancylightModel.method_2828(matrices,
                vertexConsumers.getBuffer(class_1921.method_23580(LIGHT_TEXTURE)),
                light, overlay, 1.0F, 1.0F, 1.0F, 1.0F);


        this.fancylightModel.method_2828(matrices,
                vertexConsumers.getBuffer(class_1921.method_42600(EMISSIVE_LIGHT_TEXTURE)),
                0xF000F00, overlay, 1.0F, 1.0F, 1.0F, 1.0F);

        matrices.method_22909();
    }
}
