package com.addie.datagen.providers;

import com.addie.StargateNetwork;
import dev.amble.lib.datagen.model.AmbleModelProvider;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_4915;
import net.minecraft.class_4941;
import net.minecraft.class_4942;
import net.minecraft.class_4944;
import net.minecraft.class_4945;
import net.minecraft.data.client.*;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class StargateNetworkModelGen extends AmbleModelProvider {
    private final List<class_2248> directionalBlocksToRegister = new ArrayList<>();
    private final List<class_2248> simpleBlocksToRegister = new ArrayList<>();

    public StargateNetworkModelGen (FabricDataOutput output) {
        super(output);
    }

    private static class_4942 item(String modid, String parent, class_4945... requiredTextureKeys) {
        return new class_4942(Optional.of(new class_2960(modid, "item/" + parent)), Optional.empty(), requiredTextureKeys);
    }

    private static class_4942 item(String parent, class_4945... requiredTextureKeys) {
        return item(StargateNetwork.MOD_ID, parent, requiredTextureKeys);
    }

    private static class_4942 item(class_4945... requiredTextureKeys) {
        return item("minecraft", "generated", requiredTextureKeys);
    }

    private static class_4942 item(String name) {
        return item(name, class_4945.field_23006);
    }

    private static String getItemName(class_1792 item) {
        return item.method_7876().split("\\.")[2];
    }


    public void registerDirectionalBlock(class_2248 block) {
        directionalBlocksToRegister.add(block);
    }


    public void registerSimpleBlock(class_2248 block) {
        simpleBlocksToRegister.add(block);
    }

    private void registerItem(class_4915 generator, class_1792 item, String modid) {
        class_4942 model = item(class_4945.field_23006);
        model.method_25852(class_4941.method_25840(item), createTextureMap(item, modid), generator.field_22844);
    }

    private class_4944 createTextureMap(class_1792 item, String modid) {
        class_2960 texture = new class_2960(modid, "item/" + getItemName(item));
        if (!(doesTextureExist(texture))) {
            texture = StargateNetwork.id("item/error");
        }

        return new class_4944().method_25868(class_4945.field_23006, texture);
    }

    public boolean doesTextureExist(class_2960 texture) {
        return this.output.getModContainer().findPath("assets/" + texture.method_12836() + "/textures/" + texture.method_12832() + ".png").isPresent();
    }
}


