package com.addie.core.blockentites;


import com.addie.StargateNetwork;
import com.addie.core.StargateNetworkBlockEntityTypes;
import com.addie.core.blocks.ElevatorDoorBlock;
import dev.amble.lib.animation.AnimatedBlockEntity;
import dev.amble.lib.client.bedrock.BedrockAnimationReference;
import dev.amble.lib.client.bedrock.BedrockModelReference;
import lombok.Getter;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_5558;
import net.minecraft.class_7094;
import org.jetbrains.annotations.Nullable;

public class ElevatorDoorBlockEntity  extends class_2586 implements AnimatedBlockEntity, class_5558<ElevatorDoorBlockEntity> {
    private static final BedrockModelReference MODEL = new BedrockModelReference(StargateNetwork.MOD_ID, "elevator_door_block");

    @Getter
    private final class_7094 animationState = new class_7094();
    @Getter
    private int age = 0;

    public ElevatorDoorBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public ElevatorDoorBlockEntity(class_2338 pos, class_2680 state) {
        this(StargateNetworkBlockEntityTypes.ELEVATOR_DOOR_BLOCK, pos, state);
    }

    @Override
    public String getModId() {
        return StargateNetwork.MOD_ID;
    }

    @Override
    public String getTexturePrefix() {
        return "block";
    }

    @Override
    public @Nullable BedrockModelReference getModel() {
        return MODEL;
    }

    @Override
    public boolean hasEmission() {
        return false;
    }

    @Override
    public void tick(class_1937 world, class_2338 pos, class_2680 state, ElevatorDoorBlockEntity blockEntity) {
        age++;
    }


    public void useOn(class_1937 world, boolean sneaking, class_1657 player) {
        if (world.field_9236) return;
        class_2680 state = world.method_8320(field_11867);

        if (state.method_11654(ElevatorDoorBlock.OPEN)) {
            this.playAnimation(new BedrockAnimationReference("elevator_door_block", "animation.model.open"));
        } else {
            this.playAnimation(new BedrockAnimationReference("elevator_door_block", "animation.model.close"));
        }
    }
}


